/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.exception.ConstructionException;

public abstract class AbstractSequence
extends CVCObject {
    private static final long serialVersionUID = 1L;
    private final Map<CVCTagEnum, CVCObject> subfields = new HashMap<CVCTagEnum, CVCObject>();
    private final List<CVCTagEnum> allowedFields = Arrays.asList(this.getAllowedFields());

    AbstractSequence(CVCTagEnum type) {
        super(type);
    }

    void addSubfield(CVCObject field) throws ConstructionException {
        this.addSubfield(field, false);
    }

    void addSubfield(CVCObject field, boolean override) throws ConstructionException {
        if (field != null) {
            if (this.allowedFields.contains((Object)field.getTag())) {
                if (this.subfields.containsKey((Object)field.getTag()) && !override) {
                    throw new ConstructionException("Field " + (Object)((Object)field.getTag()) + " has already been added to " + this.getClass().getName());
                }
                field.setParent(this);
                this.subfields.put(field.getTag(), field);
            } else {
                throw new ConstructionException("Field " + (Object)((Object)field.getTag()) + " not allowed in " + this.getClass().getName());
            }
        }
    }

    protected abstract CVCTagEnum[] getAllowedFields();

    CVCObject getSubfield(CVCTagEnum fieldTag) throws NoSuchFieldException {
        CVCObject subfield = this.subfields.get((Object)fieldTag);
        if (subfield == null) {
            throw new NoSuchFieldException("Could not find subfield " + (Object)((Object)fieldTag));
        }
        return subfield;
    }

    CVCObject getOptionalSubfield(CVCTagEnum tag) {
        return this.subfields.get((Object)tag);
    }

    protected Collection<CVCObject> getSubfields() {
        return this.subfields.values();
    }

    @Override
    public int encode(DataOutputStream pOut) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        int seqLength = 0;
        for (CVCObject subfield : this.getEncodableFields()) {
            seqLength += subfield.encode(dout);
        }
        dout.close();
        int tag = this.getTag().getValue();
        int s0 = pOut.size();
        pOut.write(AbstractSequence.toByteArray(tag));
        pOut.write(AbstractSequence.encodeLength(seqLength));
        pOut.write(bout.toByteArray());
        return pOut.size() - s0;
    }

    protected List<CVCObject> getEncodableFields() {
        return this.getOrderedSubfields();
    }

    public byte[] getDEREncoded() throws IOException {
        try (ByteArrayOutputStream bout = null;){
            bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            this.encode(dout);
        }
        return bout.toByteArray();
    }

    @Override
    public String getAsText(String tab) {
        return this.getAsText(tab, true);
    }

    @Override
    public String getAsText(String tab, boolean showTagNo) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getAsText(tab, showTagNo));
        for (CVCObject field : this.getOrderedSubfields()) {
            sb.append(NEWLINE);
            sb.append(field.getAsText(tab + "   ", showTagNo));
        }
        return sb.toString();
    }

    protected List<CVCObject> getOrderedSubfields() {
        ArrayList<CVCObject> orderedList = new ArrayList<CVCObject>();
        for (CVCTagEnum tag : this.allowedFields) {
            CVCObject subfield = this.subfields.get((Object)tag);
            if (subfield == null) continue;
            orderedList.add(subfield);
        }
        return orderedList;
    }
}

