/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.Serializable;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.util.StringConverter;

public class AccessRightAuthTerm
implements AccessRights,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_BIT = 37;
    public static final int BIT_WRITE_DG17 = 37;
    public static final int BIT_WRITE_DG18 = 36;
    public static final int BIT_WRITE_DG19 = 35;
    public static final int BIT_WRITE_DG20 = 34;
    public static final int BIT_WRITE_DG21 = 33;
    public static final int BIT_READ_DG21 = 28;
    public static final int BIT_READ_DG20 = 27;
    public static final int BIT_READ_DG19 = 26;
    public static final int BIT_READ_DG18 = 25;
    public static final int BIT_READ_DG17 = 24;
    public static final int BIT_READ_DG16 = 23;
    public static final int BIT_READ_DG15 = 22;
    public static final int BIT_READ_DG14 = 21;
    public static final int BIT_READ_DG13 = 20;
    public static final int BIT_READ_DG12 = 19;
    public static final int BIT_READ_DG11 = 18;
    public static final int BIT_READ_DG10 = 17;
    public static final int BIT_READ_DG9 = 16;
    public static final int BIT_READ_DG8 = 15;
    public static final int BIT_READ_DG7 = 14;
    public static final int BIT_READ_DG6 = 13;
    public static final int BIT_READ_DG5 = 12;
    public static final int BIT_READ_DG4 = 11;
    public static final int BIT_READ_DG3 = 10;
    public static final int BIT_READ_DG2 = 9;
    public static final int BIT_READ_DG1 = 8;
    public static final int BIT_INSTALL_QUALIFIED_CERT = 7;
    public static final int BIT_INSTALL_CERT = 6;
    public static final int BIT_PIN_MANAGEMENT = 5;
    public static final int BIT_CAN_ALLOWED = 4;
    public static final int BIT_PRIVILEGED_TERMINAL = 3;
    public static final int BIT_RESTRICTED_IDENTIFICATION = 2;
    public static final int BIT_COMMUNITY_ID_VERIFICATION = 1;
    public static final int BIT_AGE_VERIFICATION = 0;
    private final byte[] bytes;

    public AccessRightAuthTerm() {
        this.bytes = new byte[5];
    }

    public AccessRightAuthTerm(byte[] bytes) {
        if (bytes.length != 5) {
            throw new IllegalArgumentException("byte array length must be 5, was " + bytes.length);
        }
        this.bytes = (byte[])bytes.clone();
        this.bytes[0] = (byte)(this.bytes[0] & 0xFFFFFF3F);
    }

    public boolean getFlag(int bitNumber) {
        if (bitNumber < 0 || bitNumber > 37) {
            throw new ArrayIndexOutOfBoundsException(bitNumber);
        }
        int byteindex = this.bytes.length - 1 - (bitNumber >> 3);
        int bit = this.bytes[byteindex] >> (bitNumber & 7) & 1;
        return bit == 1;
    }

    public void setFlag(int bitNumber, boolean state) {
        if (bitNumber < 0 || bitNumber > 37) {
            throw new ArrayIndexOutOfBoundsException(bitNumber);
        }
        int byteindex = this.bytes.length - 1 - (bitNumber >> 3);
        int bit = 1 << (bitNumber & 7);
        int n = byteindex;
        this.bytes[n] = (byte)(this.bytes[n] & ~bit);
        int n2 = byteindex;
        this.bytes[n2] = (byte)(this.bytes[n2] | (state ? bit : 0));
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.bytes.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 37; ++i) {
            if (!this.getFlag(i)) continue;
            sb.append(AccessRightAuthTerm.flagToString(i));
            sb.append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    private static String flagToString(int flag) {
        if (flag < 0 || flag > 37) {
            throw new ArrayIndexOutOfBoundsException(flag);
        }
        if (flag >= 33) {
            return "W-DG" + (54 - flag);
        }
        if (flag > 28) {
            return "RFU-" + flag;
        }
        if (flag >= 8) {
            return "R-DG" + (flag - 8 + 1);
        }
        switch (flag) {
            case 7: {
                return "Install Qualified Certificate";
            }
            case 6: {
                return "Install Certificate";
            }
            case 5: {
                return "PIN Management";
            }
            case 4: {
                return "CAN Allowed";
            }
            case 3: {
                return "Privileged Terminal";
            }
            case 2: {
                return "Restricted Identification";
            }
            case 1: {
                return "Community ID Verification";
            }
            case 0: {
                return "Age Verification";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String name() {
        return "ACCESS_RIGHT_AT_" + StringConverter.byteToHex(this.bytes);
    }
}

