/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AuthorizationRole;

public enum AuthorizationRoleSignTermEnum implements AuthorizationRole
{
    CVCA(192),
    DV_AB(128),
    DV_CSP(64),
    SIGNTERM(0);

    private byte value;

    private AuthorizationRoleSignTermEnum(int value) {
        this.value = (byte)value;
    }

    @Override
    public byte getValue() {
        return this.value;
    }

    @Override
    public boolean isCVCA() {
        return this == CVCA;
    }

    @Override
    public boolean isDV() {
        return this == DV_AB || this == DV_CSP;
    }

    @Override
    public boolean isDomesticDV() {
        return false;
    }

    @Override
    public boolean isForeignDV() {
        return false;
    }

    @Override
    public boolean isAccreditationBodyDV() {
        return this == DV_AB;
    }

    @Override
    public boolean isCertificationServiceProviderDV() {
        return this == DV_CSP;
    }

    @Override
    public boolean isIS() {
        return false;
    }

    @Override
    public boolean isAuthenticationTerminal() {
        return false;
    }

    @Override
    public boolean isSignatureTerminal() {
        return this == SIGNTERM;
    }

    public String toString() {
        switch (this) {
            case CVCA: {
                return "CVCA";
            }
            case DV_AB: {
                return "DV-Accreditation-Body";
            }
            case DV_CSP: {
                return "DV-Certification-Service-Provider";
            }
            case SIGNTERM: {
                return "Signature-Terminal";
            }
        }
        throw new IllegalStateException("Enum case not handled");
    }
}

