/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.CVCTagEnum;

public abstract class CVCObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CVC_VERSION = 0;
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final int INT_LENGTH = 4;
    private static final int LONG_LENGTH = 8;
    private final CVCTagEnum tag;
    private AbstractSequence parent;

    public CVCObject(CVCTagEnum tag) {
        this.tag = tag;
    }

    public CVCTagEnum getTag() {
        return this.tag;
    }

    public AbstractSequence getParent() {
        return this.parent;
    }

    public void setParent(AbstractSequence parent) {
        this.parent = parent;
    }

    protected abstract int encode(DataOutputStream var1) throws IOException;

    protected static byte[] encodeLength(int lenValue) {
        int lenBytes = 0;
        if (lenValue > 127) {
            lenBytes = 1;
            if (lenValue > 255) {
                lenBytes = 2;
            }
        }
        ByteBuffer bb = ByteBuffer.allocate(1 + lenBytes);
        if (lenBytes == 0) {
            bb.put(0, (byte)lenValue);
        } else {
            bb.put(0, (byte)(128 + lenBytes));
            if (lenBytes == 1) {
                bb.put(1, (byte)lenValue);
            } else {
                bb.putShort(1, (short)lenValue);
            }
        }
        return bb.array();
    }

    protected static int decodeLength(DataInputStream in) throws IOException {
        int lenBytes = 1;
        int length = 0;
        int b1 = in.read();
        length = b1 > 127 ? ((lenBytes = b1 & 0xF) == 1 ? in.readUnsignedByte() : (int)in.readShort()) : b1;
        return length;
    }

    protected static byte[] toByteArray(Integer intVal) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(intVal);
        return CVCObject.trimByteArray(bb.array());
    }

    protected static byte[] toByteArray(Long longVal) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putLong(longVal);
        return CVCObject.trimByteArray(bb.array());
    }

    protected static byte[] trimByteArray(byte[] data) {
        boolean numberFound = false;
        int pos = 0;
        for (pos = 0; pos < data.length; ++pos) {
            boolean bl = numberFound = data[pos] != 0;
            if (numberFound) break;
        }
        byte[] result = null;
        if (numberFound) {
            result = new byte[data.length - pos];
            System.arraycopy(data, pos, result, 0, data.length - pos);
        } else {
            result = new byte[]{0};
        }
        return result;
    }

    public String getAsText() {
        return this.getAsText("", true);
    }

    public String getAsText(boolean showTagNo) {
        return this.getAsText("", showTagNo);
    }

    public String getAsText(String tab) {
        return this.getAsText(tab, true);
    }

    public String getAsText(String tab, boolean showTagNo) {
        StringBuffer sb = new StringBuffer();
        sb.append(tab);
        if (showTagNo) {
            sb.append(Integer.toHexString(this.getTag().getValue())).append(' ');
        }
        sb.append(this.getTag().name()).append("  ");
        return sb.toString();
    }
}

