/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.FieldFactory;
import org.ejbca.cvc.GenericPublicKeyField;
import org.ejbca.cvc.KeyFactory;
import org.ejbca.cvc.SequenceFactory;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.exception.ParseException;

public final class CertificateParser {
    private CertificateParser() {
    }

    public static CVCObject parseCVCObject(byte[] data) throws ParseException, ConstructionException {
        return CertificateParser.decode(data, null);
    }

    public static CVCertificate parseCertificate(byte[] data) throws ParseException, ConstructionException {
        return (CVCertificate)CertificateParser.decode(data, CVCTagEnum.CV_CERTIFICATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CVCObject decode(byte[] data, CVCTagEnum expectedTag) throws ParseException, ConstructionException {
        CVCObject cVCObject;
        block6: {
            ByteArrayInputStream bin = null;
            try {
                bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                cVCObject = CertificateParser.decode(din, expectedTag, null);
                if (bin == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (bin != null) {
                        bin.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ParseException(e);
                }
            }
            bin.close();
        }
        return cVCObject;
    }

    private static CVCObject decode(DataInputStream din, CVCTagEnum expectedTag, CVCTagEnum tagIfAmbiguous) throws IOException, ConstructionException, ParseException {
        int tagValue = CertificateParser.decodeTag(din);
        CVCTagEnum tag = CertificateParser.findTagFromValue(tagValue);
        if (expectedTag != null && tag != expectedTag) {
            throw new ParseException("Expected first tag " + (Object)((Object)expectedTag) + " but found " + (Object)((Object)tag));
        }
        if (tagIfAmbiguous != null && tag.getValue() == tagIfAmbiguous.getValue()) {
            tag = tagIfAmbiguous;
        }
        int length = CVCObject.decodeLength(din);
        if (tag.isSequence()) {
            int sequenceEnd = din.available() - length;
            AbstractSequence sequence = SequenceFactory.createSequence(tag);
            while (din.available() > sequenceEnd) {
                CVCTagEnum nestedTagIfAmbiguous;
                switch (tag) {
                    case DISCRETIONARY_DATA_TEMPLATE: {
                        nestedTagIfAmbiguous = CVCTagEnum.ARBITRARY_DATA;
                        break;
                    }
                    default: {
                        nestedTagIfAmbiguous = null;
                    }
                }
                sequence.addSubfield(CertificateParser.decode(din, null, nestedTagIfAmbiguous));
            }
            if (sequence instanceof GenericPublicKeyField) {
                sequence = KeyFactory.createInstance((GenericPublicKeyField)sequence);
            }
            return sequence;
        }
        byte[] data = new byte[length];
        din.read(data, 0, length);
        return FieldFactory.decodeField(tag, data);
    }

    private static CVCTagEnum findTagFromValue(int tagvalue) throws ParseException {
        CVCTagEnum wantedType = null;
        for (CVCTagEnum type : CVCTagEnum.values()) {
            if (type.getValue() != tagvalue) continue;
            wantedType = type;
            break;
        }
        if (wantedType != null) {
            return wantedType;
        }
        throw new ParseException("Unknown CVC tag value " + Integer.toHexString(tagvalue));
    }

    private static int decodeTag(DataInputStream din) throws IOException {
        int tagValue = 0;
        int b1 = din.readUnsignedByte();
        if ((b1 & 0x1F) == 31) {
            byte b2 = din.readByte();
            tagValue = (b1 << 8) + b2;
        } else {
            tagValue = b1;
        }
        return tagValue;
    }
}

