/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.jce.ECPointUtil;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AuthorizationField;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CVCAuthorizationTemplate;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.GenericPublicKeyField;
import org.ejbca.cvc.IntegerField;
import org.ejbca.cvc.OIDField;
import org.ejbca.cvc.exception.ConstructionException;

public class PublicKeyEC
extends CVCPublicKey
implements ECPublicKey {
    static final long serialVersionUID = 1L;
    public static final byte UNCOMPRESSED_POINT_TAG = 4;
    private static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.OID, CVCTagEnum.MODULUS, CVCTagEnum.COEFFICIENT_A, CVCTagEnum.COEFFICIENT_B, CVCTagEnum.BASE_POINT_G, CVCTagEnum.BASE_POINT_R_ORDER, CVCTagEnum.PUBLIC_POINT_Y, CVCTagEnum.COFACTOR_F};

    @Override
    protected CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    public PublicKeyEC(GenericPublicKeyField genericKey) throws ConstructionException, NoSuchFieldException {
        this.addSubfield(genericKey.getSubfield(CVCTagEnum.OID));
        this.addSubfield(genericKey.getOptionalSubfield(CVCTagEnum.MODULUS));
        this.addSubfield(genericKey.getOptionalSubfield(CVCTagEnum.COEFFICIENT_A));
        this.addSubfield(genericKey.getOptionalSubfield(CVCTagEnum.COEFFICIENT_B));
        this.addSubfield(genericKey.getOptionalSubfield(CVCTagEnum.BASE_POINT_G));
        this.addSubfield(genericKey.getOptionalSubfield(CVCTagEnum.BASE_POINT_R_ORDER));
        this.addSubfield(genericKey.getSubfield(CVCTagEnum.PUBLIC_POINT_Y));
        this.addSubfield(genericKey.getOptionalSubfield(CVCTagEnum.COFACTOR_F));
    }

    public PublicKeyEC(OIDField oid, ECPublicKey pubKeyEC, AuthorizationRole authRole) throws ConstructionException {
        boolean addAllParams;
        this.addSubfield(oid);
        ECParameterSpec ecParameterSpec = pubKeyEC.getParams();
        boolean bl = addAllParams = authRole == null || authRole.isCVCA();
        if (addAllParams) {
            ECField ecField = ecParameterSpec.getCurve().getField();
            if (ecField instanceof ECFieldFp) {
                ECFieldFp fp = (ECFieldFp)ecField;
                this.addSubfield(new ByteField(CVCTagEnum.MODULUS, PublicKeyEC.trimByteArray(fp.getP().toByteArray())));
            }
            this.addSubfield(new ByteField(CVCTagEnum.COEFFICIENT_A, PublicKeyEC.trimByteArray(ecParameterSpec.getCurve().getA().toByteArray())));
            this.addSubfield(new ByteField(CVCTagEnum.COEFFICIENT_B, PublicKeyEC.trimByteArray(ecParameterSpec.getCurve().getB().toByteArray())));
            this.addSubfield(new ByteField(CVCTagEnum.BASE_POINT_G, PublicKeyEC.encodePoint(ecParameterSpec.getGenerator(), ecParameterSpec.getCurve())));
            this.addSubfield(new ByteField(CVCTagEnum.BASE_POINT_R_ORDER, PublicKeyEC.trimByteArray(ecParameterSpec.getOrder().toByteArray())));
        }
        this.addSubfield(new ByteField(CVCTagEnum.PUBLIC_POINT_Y, PublicKeyEC.encodePoint(pubKeyEC.getW(), ecParameterSpec.getCurve())));
        if (addAllParams) {
            this.addSubfield(new IntegerField(CVCTagEnum.COFACTOR_F, ecParameterSpec.getCofactor()));
        }
    }

    public PublicKeyEC(OIDField oid, ECPublicKey pubKeyEC, AuthorizationRoleEnum authRole) throws ConstructionException {
        this(oid, pubKeyEC, (AuthorizationRole)authRole);
    }

    @Override
    protected List<CVCObject> getEncodableFields() {
        try {
            ECParameterSpec ecParameterSpec;
            boolean addAllParams;
            ArrayList<CVCObject> list;
            block12: {
                list = new ArrayList<CVCObject>();
                list.add(this.getSubfield(CVCTagEnum.OID));
                addAllParams = false;
                ecParameterSpec = this.getParams();
                if (ecParameterSpec != null) {
                    AbstractSequence parent = this.getParent();
                    if (parent != null && parent.getTag() == CVCTagEnum.CERTIFICATE_BODY) {
                        try {
                            CVCObject cvcObj = ((CVCertificateBody)parent).getOptionalSubfield(CVCTagEnum.HOLDER_AUTH_TEMPLATE);
                            if (cvcObj == null) {
                                addAllParams = true;
                                break block12;
                            }
                            AuthorizationField authField = ((CVCAuthorizationTemplate)cvcObj).getAuthorizationField();
                            addAllParams = authField != null && authField.getAuthRole().isCVCA();
                        }
                        catch (NoSuchFieldException noSuchFieldException) {}
                    } else if (parent == null) {
                        addAllParams = true;
                    }
                }
            }
            if (addAllParams) {
                ECField ecField = ecParameterSpec.getCurve().getField();
                if (ecField instanceof ECFieldFp) {
                    list.add(this.getSubfield(CVCTagEnum.MODULUS));
                }
                list.add(this.getSubfield(CVCTagEnum.COEFFICIENT_A));
                list.add(this.getSubfield(CVCTagEnum.COEFFICIENT_B));
                list.add(this.getSubfield(CVCTagEnum.BASE_POINT_G));
                list.add(this.getSubfield(CVCTagEnum.BASE_POINT_R_ORDER));
            }
            list.add(this.getSubfield(CVCTagEnum.PUBLIC_POINT_Y));
            if (addAllParams) {
                list.add(this.getSubfield(CVCTagEnum.COFACTOR_F));
            }
            return list;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getAlgorithm() {
        return "ECDSA";
    }

    @Override
    public String getFormat() {
        return "CVC";
    }

    @Override
    public ECParameterSpec getParams() {
        ECParameterSpec ecParameterSpec = null;
        ByteField modulus = (ByteField)this.getOptionalSubfield(CVCTagEnum.MODULUS);
        ByteField coefficient_a = (ByteField)this.getOptionalSubfield(CVCTagEnum.COEFFICIENT_A);
        ByteField coefficient_b = (ByteField)this.getOptionalSubfield(CVCTagEnum.COEFFICIENT_B);
        ByteField base_point_g = (ByteField)this.getOptionalSubfield(CVCTagEnum.BASE_POINT_G);
        ByteField point_r_order = (ByteField)this.getOptionalSubfield(CVCTagEnum.BASE_POINT_R_ORDER);
        IntegerField cofactor = (IntegerField)this.getOptionalSubfield(CVCTagEnum.COFACTOR_F);
        if (modulus != null) {
            EllipticCurve curve = new EllipticCurve(new ECFieldFp(new BigInteger(1, modulus.getData())), new BigInteger(1, coefficient_a.getData()), new BigInteger(1, coefficient_b.getData()));
            ecParameterSpec = new ECParameterSpec(curve, ECPointUtil.decodePoint((EllipticCurve)curve, (byte[])base_point_g.getData()), new BigInteger(1, point_r_order.getData()), cofactor.getValue());
        }
        return ecParameterSpec;
    }

    @Override
    public ECPoint getW() {
        try {
            ByteField public_point_y = (ByteField)this.getSubfield(CVCTagEnum.PUBLIC_POINT_Y);
            return PublicKeyEC.decodePoint(public_point_y.getData());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] encodePoint(ECPoint ecPoint, EllipticCurve curve) {
        byte[] pointX = PublicKeyEC.trimByteArray(ecPoint.getAffineX().toByteArray());
        byte[] pointY = PublicKeyEC.trimByteArray(ecPoint.getAffineY().toByteArray());
        int n = 0;
        n = curve != null ? curve.getField().getFieldSize() + 7 >> 3 : (pointX.length > pointY.length ? pointX.length : pointY.length);
        int paddingX_length = 0;
        int paddingY_length = 0;
        if (pointX.length < n) {
            paddingX_length = n - pointX.length;
        }
        if (pointY.length < n) {
            paddingY_length = n - pointY.length;
        }
        byte[] encoded = new byte[1 + (n << 1)];
        Arrays.fill(encoded, (byte)0);
        encoded[0] = 4;
        System.arraycopy(pointX, 0, encoded, 1 + paddingX_length, n - paddingX_length);
        System.arraycopy(pointY, 0, encoded, 1 + n + paddingY_length, n - paddingY_length);
        return encoded;
    }

    public static ECPoint decodePoint(byte[] data) {
        if (data[0] != 4) {
            throw new IllegalArgumentException("First byte must be 0x4");
        }
        byte[] xEnc = new byte[(data.length - 1) / 2];
        byte[] yEnc = new byte[(data.length - 1) / 2];
        System.arraycopy(data, 1, xEnc, 0, xEnc.length);
        System.arraycopy(data, xEnc.length + 1, yEnc, 0, yEnc.length);
        return new ECPoint(new BigInteger(1, xEnc), new BigInteger(1, yEnc));
    }
}

