/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc.example;

import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCObject;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CertificateGenerator;
import org.ejbca.cvc.CertificateParser;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.example.FileHelper;

public final class GenerateCert {
    private GenerateCert() {
    }

    public static void main(String[] args) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
            keyGen.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyGen.generateKeyPair();
            CAReferenceField caRef = new CAReferenceField("SE", "PASS-CVCA", "00111");
            HolderReferenceField holderRef = new HolderReferenceField(caRef.getCountry(), caRef.getMnemonic(), caRef.getSequence());
            CVCertificate cvc = CertificateGenerator.createTestCertificate(keyPair.getPublic(), keyPair.getPrivate(), caRef, holderRef, "SHA1WithRSA", AuthorizationRoleEnum.IS);
            byte[] certData = cvc.getDEREncoded();
            String filename = "C:/cv_certs/mycert1.cvcert";
            FileHelper.writeFile(new File(filename), certData);
            certData = FileHelper.loadFile(new File(filename));
            CVCertificate parsedObject = CertificateParser.parseCertificate(certData);
            System.out.println(((CVCObject)parsedObject).getAsText(""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

