/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public final class BCECUtil {
    private BCECUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertX962SigToCVC(String algorithmName, byte[] xsig) throws IOException {
        ASN1Sequence seq;
        if (!algorithmName.toUpperCase(Locale.getDefault()).contains("EC")) {
            return xsig;
        }
        try (ASN1InputStream aIn = new ASN1InputStream(xsig);){
            seq = (ASN1Sequence)aIn.readObject();
        }
        BigInteger r = ((ASN1Integer)seq.getObjectAt(0)).getValue();
        BigInteger s = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        byte[] first = BCECUtil.makeUnsigned(r);
        byte[] second = BCECUtil.makeUnsigned(s);
        byte[] res = first.length > second.length ? new byte[first.length * 2] : new byte[second.length * 2];
        System.arraycopy(first, 0, res, res.length / 2 - first.length, first.length);
        System.arraycopy(second, 0, res, res.length - second.length, second.length);
        return res;
    }

    public static byte[] convertCVCSigToX962(String algorithmName, byte[] xsig) throws SignatureException {
        if (!algorithmName.toUpperCase(Locale.getDefault()).contains("EC")) {
            return xsig;
        }
        byte[] first = new byte[xsig.length / 2];
        byte[] second = new byte[xsig.length / 2];
        System.arraycopy(xsig, 0, first, 0, first.length);
        System.arraycopy(xsig, first.length, second, 0, second.length);
        BigInteger r = new BigInteger(1, first);
        BigInteger s = new BigInteger(1, second);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream dOut = ASN1OutputStream.create((OutputStream)bOut, (String)"DER");
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            dOut.writeObject((ASN1Primitive)new DERSequence(v));
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
        return bOut.toByteArray();
    }

    private static byte[] makeUnsigned(BigInteger val) {
        byte[] res = val.toByteArray();
        if (res[0] == 0) {
            byte[] tmp = new byte[res.length - 1];
            System.arraycopy(res, 1, tmp, 0, tmp.length);
            res = tmp;
        }
        return res;
    }
}

