/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc.util;

public final class StringConverter {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String HEXINDEX = "0123456789abcdef          ABCDEF";

    private StringConverter() {
    }

    public static byte[] hexToByte(String s) {
        int l = s.length() / 2;
        byte[] data = new byte[l];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(j++);
            int n = HEXINDEX.indexOf(c);
            int b = (n & 0xF) << 4;
            c = s.charAt(j++);
            n = HEXINDEX.indexOf(c);
            data[i] = (byte)(b += n & 0xF);
        }
        return data;
    }

    public static String byteToHex(byte[] b) {
        return StringConverter.byteToHex(b, null);
    }

    public static String byteToHex(byte[] b, String sep) {
        int len = b.length;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(StringConverter.byteToHex(b[i]));
            if (sep == null || i + 1 >= len) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String byteToHex(byte b) {
        int c = b & 0xFF;
        char c1 = HEXCHAR[c >> 4 & 0xF];
        char c2 = HEXCHAR[c & 0xF];
        return Character.toString(c1) + c2;
    }
}

