/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AccessRights;

public enum AccessRightSignTermEnum implements AccessRights
{
    ACCESS_NONE(0),
    ACCESS_SIGN(1),
    ACCESS_QUALSIGN(2),
    ACCESS_SIGN_AND_QUALSIGN(3);

    private byte value;

    private AccessRightSignTermEnum(int value) {
        this.value = (byte)value;
    }

    public byte getValue() {
        return this.value;
    }

    public boolean allowsSignature() {
        return (this.value & AccessRightSignTermEnum.ACCESS_SIGN.value) != 0;
    }

    public boolean allowsQualifiedSignature() {
        return (this.value & AccessRightSignTermEnum.ACCESS_QUALSIGN.value) != 0;
    }

    @Override
    public byte[] getEncoded() {
        return new byte[]{this.value};
    }

    public String toString() {
        switch (this) {
            case ACCESS_SIGN: {
                return "Signature";
            }
            case ACCESS_QUALSIGN: {
                return "Qualified_Signature";
            }
            case ACCESS_SIGN_AND_QUALSIGN: {
                return "Signature_and_Qualified_Signature";
            }
            case ACCESS_NONE: {
                return "none";
            }
        }
        throw new IllegalStateException("Enum case not handled");
    }
}

