/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.IOException;
import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.AuthorizationField;
import org.ejbca.cvc.ByteField;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.DateField;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.IntegerField;
import org.ejbca.cvc.OIDField;

public class FieldFactory {
    public static AbstractDataField decodeField(CVCTagEnum tag, byte[] data) throws IOException {
        if (tag.isSequence()) {
            throw new IllegalArgumentException("Tag " + (Object)((Object)tag) + " is a sequence");
        }
        AbstractDataField fieldObject = null;
        switch (tag) {
            case EFFECTIVE_DATE: {
                fieldObject = new DateField(tag, data);
                break;
            }
            case EXPIRATION_DATE: {
                fieldObject = new DateField(tag, data);
                break;
            }
            case CA_REFERENCE: {
                fieldObject = new CAReferenceField(data);
                break;
            }
            case HOLDER_REFERENCE: {
                fieldObject = new HolderReferenceField(data);
                break;
            }
            case OID: {
                fieldObject = new OIDField(data);
                break;
            }
            case ROLE_AND_ACCESS_RIGHTS: {
                fieldObject = new AuthorizationField(data);
                break;
            }
            case PROFILE_IDENTIFIER: {
                fieldObject = new IntegerField(tag, data);
                break;
            }
            case COFACTOR_F: {
                fieldObject = new IntegerField(tag, data);
                break;
            }
            default: {
                fieldObject = new ByteField(tag, data);
            }
        }
        return fieldObject;
    }
}

