/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.math.BigInteger;
import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCTagEnum;

public class IntegerField
extends AbstractDataField {
    private static final long serialVersionUID = 1L;
    private int intValue;

    IntegerField(CVCTagEnum tag, int value) {
        super(tag);
        this.intValue = value;
    }

    IntegerField(CVCTagEnum tag, byte[] data) {
        super(tag);
        if (data != null && data.length > 4) {
            throw new IllegalArgumentException("Byte array too long, max is 4, was " + data.length);
        }
        this.intValue = new BigInteger(1, data).intValue();
    }

    public void setValue(int intValue) {
        this.intValue = intValue;
    }

    public int getValue() {
        return this.intValue;
    }

    @Override
    protected byte[] getEncoded() {
        return IntegerField.toByteArray(this.intValue);
    }

    @Override
    protected String valueAsText() {
        return "" + this.intValue;
    }
}

