/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.ejbca.cvc.AbstractDataField;
import org.ejbca.cvc.CVCTagEnum;

public class OIDField
extends AbstractDataField {
    private static final long serialVersionUID = 5212215839749666908L;
    private String id;

    OIDField() {
        super(CVCTagEnum.OID);
    }

    OIDField(String id) {
        this();
        this.id = id;
    }

    OIDField(byte[] data) {
        this();
        this.id = ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)new DERTaggedObject(true, 0, (ASN1Encodable)new DEROctetString(data)), (boolean)false).getId();
    }

    public String getValue() {
        return this.id;
    }

    @Override
    protected byte[] getEncoded() {
        byte[] encoding = null;
        try {
            byte[] derField = new ASN1ObjectIdentifier(this.id).getEncoded();
            encoding = new byte[derField.length - 2];
            System.arraycopy(derField, 2, encoding, 0, encoding.length);
            return encoding;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    protected String valueAsText() {
        return this.id;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean equals(Object other) {
        if (other instanceof OIDField) {
            return this.id.equals(((OIDField)other).getValue());
        }
        return false;
    }
}

