/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition;

import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;

public class UtilDecompositons_D64 {
    public static DenseMatrix64F checkIdentity(DenseMatrix64F A, int numRows, int numCols) {
        if (A == null) {
            return CommonOps.identity(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        CommonOps.setIdentity((RowD1Matrix64F)A);
        return A;
    }

    public static DenseMatrix64F checkZeros(DenseMatrix64F A, int numRows, int numCols) {
        if (A == null) {
            return new DenseMatrix64F(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        A.zero();
        return A;
    }

    public static DenseMatrix64F checkZerosLT(DenseMatrix64F A, int numRows, int numCols) {
        if (A == null) {
            return new DenseMatrix64F(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        for (int i = 0; i < A.numRows; ++i) {
            int index = i * A.numCols;
            int end = index + Math.min(i, A.numCols);
            while (index < end) {
                A.data[index++] = 0.0;
            }
        }
        return A;
    }

    public static DenseMatrix64F checkZerosUT(DenseMatrix64F A, int numRows, int numCols) {
        if (A == null) {
            return new DenseMatrix64F(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        int maxRows = Math.min(A.numRows, A.numCols);
        for (int i = 0; i < maxRows; ++i) {
            int index = i * A.numCols + i + 1;
            int end = i * A.numCols + A.numCols;
            while (index < end) {
                A.data[index++] = 0.0;
            }
        }
        return A;
    }
}

