/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.lu;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.UtilDecompositons_D64;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.ops.SpecializedOps;

public abstract class LUDecompositionBase_D64
implements LUDecomposition<DenseMatrix64F> {
    protected DenseMatrix64F LU;
    protected int maxWidth = -1;
    protected int m;
    protected int n;
    protected double[] dataLU;
    protected double[] vv;
    protected int[] indx;
    protected int[] pivot;
    protected double pivsign;
    Complex64F det = new Complex64F();

    public void setExpectedMaxSize(int numRows, int numCols) {
        this.LU = new DenseMatrix64F(numRows, numCols);
        this.dataLU = this.LU.data;
        this.maxWidth = Math.max(numRows, numCols);
        this.vv = new double[this.maxWidth];
        this.indx = new int[this.maxWidth];
        this.pivot = new int[this.maxWidth];
    }

    public DenseMatrix64F getLU() {
        return this.LU;
    }

    public int[] getIndx() {
        return this.indx;
    }

    public int[] getPivot() {
        return this.pivot;
    }

    public boolean inputModified() {
        return false;
    }

    public DenseMatrix64F getLower(DenseMatrix64F lower) {
        int j;
        int i;
        int numRows = this.LU.numRows;
        int numCols = this.LU.numRows < this.LU.numCols ? this.LU.numRows : this.LU.numCols;
        lower = UtilDecompositons_D64.checkZerosUT(lower, numRows, numCols);
        for (i = 0; i < numCols; ++i) {
            lower.unsafe_set(i, i, 1.0);
            for (j = 0; j < i; ++j) {
                lower.unsafe_set(i, j, this.LU.unsafe_get(i, j));
            }
        }
        if (numRows > numCols) {
            for (i = numCols; i < numRows; ++i) {
                for (j = 0; j < numCols; ++j) {
                    lower.unsafe_set(i, j, this.LU.unsafe_get(i, j));
                }
            }
        }
        return lower;
    }

    public DenseMatrix64F getUpper(DenseMatrix64F upper) {
        int numRows = this.LU.numRows < this.LU.numCols ? this.LU.numRows : this.LU.numCols;
        int numCols = this.LU.numCols;
        upper = UtilDecompositons_D64.checkZerosLT(upper, numRows, numCols);
        for (int i = 0; i < numRows; ++i) {
            for (int j = i; j < numCols; ++j) {
                upper.unsafe_set(i, j, this.LU.unsafe_get(i, j));
            }
        }
        return upper;
    }

    public DenseMatrix64F getPivot(DenseMatrix64F pivot) {
        return SpecializedOps.pivotMatrix(pivot, this.pivot, this.LU.numRows, false);
    }

    protected void decomposeCommonInit(DenseMatrix64F a) {
        if (a.numRows > this.maxWidth || a.numCols > this.maxWidth) {
            this.setExpectedMaxSize(a.numRows, a.numCols);
        }
        this.m = a.numRows;
        this.n = a.numCols;
        this.LU.set((D1Matrix64F)a);
        for (int i = 0; i < this.m; ++i) {
            this.pivot[i] = i;
        }
        this.pivsign = 1.0;
    }

    public boolean isSingular() {
        for (int i = 0; i < this.m; ++i) {
            if (!(Math.abs(this.dataLU[i * this.n + i]) < UtilEjml.EPS)) continue;
            return true;
        }
        return false;
    }

    public Complex64F computeDeterminant() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Must be a square matrix.");
        }
        double ret = this.pivsign;
        int total = this.m * this.n;
        for (int i = 0; i < total; i += this.n + 1) {
            ret *= this.dataLU[i];
        }
        this.det.real = ret;
        this.det.imaginary = 0.0;
        return this.det;
    }

    public double quality() {
        return SpecializedOps.qualityTriangular((D1Matrix64F)this.LU);
    }

    public void _solveVectorInternal(double[] vv) {
        int ii = 0;
        for (int i = 0; i < this.n; ++i) {
            int ip = this.indx[i];
            double sum = vv[ip];
            vv[ip] = vv[i];
            if (ii != 0) {
                int index = i * this.n + ii - 1;
                for (int j = ii - 1; j < i; ++j) {
                    sum -= this.dataLU[index++] * vv[j];
                }
            } else if (sum != 0.0) {
                ii = i + 1;
            }
            vv[i] = sum;
        }
        TriangularSolver.solveU(this.dataLU, vv, this.n);
    }

    public double[] _getVV() {
        return this.vv;
    }
}

