/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionInner_D64;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.DenseMatrixBool;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.decomposition.LUDecomposition;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.SingularOps;

public class MatrixFeatures {
    public static boolean hasNaN(D1Matrix64F m) {
        int length = m.getNumElements();
        for (int i = 0; i < length; ++i) {
            if (!Double.isNaN(m.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUncountable(D1Matrix64F m) {
        int length = m.getNumElements();
        for (int i = 0; i < length; ++i) {
            double a = m.get(i);
            if (!Double.isNaN(a) && !Double.isInfinite(a)) continue;
            return true;
        }
        return false;
    }

    public static boolean isZeros(D1Matrix64F m, double tol) {
        int length = m.getNumElements();
        for (int i = 0; i < length; ++i) {
            if (!(Math.abs(m.get(i)) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVector(Matrix mat) {
        return mat.getNumCols() == 1 || mat.getNumRows() == 1;
    }

    public static boolean isPositiveDefinite(DenseMatrix64F A) {
        if (!MatrixFeatures.isSquare((D1Matrix64F)A)) {
            return false;
        }
        CholeskyDecompositionInner_D64 chol = new CholeskyDecompositionInner_D64(true);
        if (chol.inputModified()) {
            A = A.copy();
        }
        return chol.decompose(A);
    }

    public static boolean isPositiveSemidefinite(DenseMatrix64F A) {
        if (!MatrixFeatures.isSquare((D1Matrix64F)A)) {
            return false;
        }
        EigenDecomposition<DenseMatrix64F> eig = DecompositionFactory.eig(A.numCols, false);
        if (eig.inputModified()) {
            A = A.copy();
        }
        eig.decompose((Matrix)A);
        for (int i = 0; i < A.numRows; ++i) {
            Complex64F v = eig.getEigenvalue(i);
            if (!(v.getReal() < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSquare(D1Matrix64F mat) {
        return mat.numCols == mat.numRows;
    }

    public static boolean isSymmetric(DenseMatrix64F m, double tol) {
        if (m.numCols != m.numRows) {
            return false;
        }
        double max = CommonOps.elementMaxAbs((D1Matrix64F)m);
        for (int i = 0; i < m.numRows; ++i) {
            for (int j = 0; j < i; ++j) {
                double b;
                double a = m.get(i, j) / max;
                double diff = Math.abs(a - (b = m.get(j, i) / max));
                if (diff <= tol) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSymmetric(DenseMatrix64F m) {
        return MatrixFeatures.isSymmetric(m, 0.0);
    }

    public static boolean isSkewSymmetric(DenseMatrix64F A, double tol) {
        if (A.numCols != A.numRows) {
            return false;
        }
        for (int i = 0; i < A.numRows; ++i) {
            for (int j = 0; j < i; ++j) {
                double b;
                double a = A.get(i, j);
                double diff = Math.abs(a + (b = A.get(j, i)));
                if (diff <= tol) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isInverse(DenseMatrix64F a, DenseMatrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        int numRows = a.numRows;
        int numCols = a.numCols;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                double total = 0.0;
                for (int k = 0; k < numCols; ++k) {
                    total += a.get(i, k) * b.get(k, j);
                }
                if (!(i == j ? !(Math.abs(total - 1.0) <= tol) : !(Math.abs(total) <= tol))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEquals(D1Matrix64F a, D1Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        if (tol == 0.0) {
            return MatrixFeatures.isEquals(a, b);
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            if (tol >= Math.abs(a.get(i) - b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualsTriangle(RealMatrix64F a, RealMatrix64F b, boolean upper, double tol) {
        if (a.getNumRows() != b.getNumRows() || a.getNumCols() != b.getNumCols()) {
            return false;
        }
        if (upper) {
            for (int i = 0; i < a.getNumRows(); ++i) {
                for (int j = i; j < a.getNumCols(); ++j) {
                    if (!(Math.abs(a.get(i, j) - b.get(i, j)) > tol)) continue;
                    return false;
                }
            }
        } else {
            for (int i = 0; i < a.getNumRows(); ++i) {
                int end = Math.min(i, a.getNumCols() - 1);
                for (int j = 0; j <= end; ++j) {
                    if (!(Math.abs(a.get(i, j) - b.get(i, j)) > tol)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEquals(D1Matrix64F a, D1Matrix64F b) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            if (a.get(i) == b.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(DenseMatrixBool a, DenseMatrixBool b) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            if (a.get(i) == b.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentical(D1Matrix64F a, D1Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        if (tol < 0.0) {
            throw new IllegalArgumentException("Tolerance must be greater than or equal to zero.");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            double valB;
            double valA = a.get(i);
            double diff = Math.abs(valA - (valB = b.get(i)));
            if (tol >= diff) continue;
            if (Double.isNaN(valA)) {
                return Double.isNaN(valB);
            }
            if (Double.isInfinite(valA)) {
                return valA == valB;
            }
            return false;
        }
        return true;
    }

    public static boolean isOrthogonal(DenseMatrix64F Q, double tol) {
        if (Q.numRows < Q.numCols) {
            throw new IllegalArgumentException("The number of rows must be more than or equal to the number of columns");
        }
        DenseMatrix64F[] u = CommonOps.columnsToVector(Q, null);
        for (int i = 0; i < u.length; ++i) {
            DenseMatrix64F a = u[i];
            for (int j = i + 1; j < u.length; ++j) {
                double val = VectorVectorMult.innerProd((D1Matrix64F)a, (D1Matrix64F)u[j]);
                if (Math.abs(val) <= tol) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isRowsLinearIndependent(DenseMatrix64F A) {
        LUDecomposition<DenseMatrix64F> lu = DecompositionFactory.lu(A.numRows, A.numCols);
        if (lu.inputModified()) {
            A = A.copy();
        }
        if (!lu.decompose((Matrix)A)) {
            throw new RuntimeException("Decompositon failed?");
        }
        return !lu.isSingular();
    }

    public static boolean isIdentity(DenseMatrix64F mat, double tol) {
        int index = 0;
        for (int i = 0; i < mat.numRows; ++i) {
            for (int j = 0; j < mat.numCols; ++j) {
                if (!(i == j ? !(Math.abs(mat.get(index++) - 1.0) <= tol) : !(Math.abs(mat.get(index++)) <= tol))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isConstantVal(DenseMatrix64F mat, double val, double tol) {
        int index = 0;
        for (int i = 0; i < mat.numRows; ++i) {
            for (int j = 0; j < mat.numCols; ++j) {
                if (Math.abs(mat.get(index++) - val) <= tol) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDiagonalPositive(DenseMatrix64F a) {
        for (int i = 0; i < a.numRows; ++i) {
            if (a.get(i, i) >= 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullRank(DenseMatrix64F a) {
        throw new RuntimeException("Implement");
    }

    public static boolean isNegative(D1Matrix64F a, D1Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            throw new IllegalArgumentException("Matrix dimensions must match");
        }
        int length = a.getNumElements();
        for (int i = 0; i < length; ++i) {
            if (Math.abs(a.get(i) + b.get(i)) <= tol) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperTriangle(DenseMatrix64F A, int hessenberg, double tol) {
        for (int i = hessenberg + 1; i < A.numRows; ++i) {
            int maxCol = Math.min(i - hessenberg, A.numCols);
            for (int j = 0; j < maxCol; ++j) {
                if (Math.abs(A.unsafe_get(i, j)) <= tol) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isLowerTriangle(DenseMatrix64F A, int hessenberg, double tol) {
        for (int i = 0; i < A.numRows - hessenberg - 1; ++i) {
            for (int j = i + hessenberg + 1; j < A.numCols; ++j) {
                if (Math.abs(A.unsafe_get(i, j)) <= tol) continue;
                return false;
            }
        }
        return true;
    }

    public static int rank(DenseMatrix64F A) {
        return MatrixFeatures.rank(A, UtilEjml.EPS * 100.0);
    }

    public static int rank(DenseMatrix64F A, double threshold) {
        SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(A.numRows, A.numCols, false, false, true);
        if (svd.inputModified()) {
            A = A.copy();
        }
        if (!svd.decompose((Matrix)A)) {
            throw new RuntimeException("Decomposition failed");
        }
        return SingularOps.rank(svd, threshold);
    }

    public static int nullity(DenseMatrix64F A) {
        return MatrixFeatures.nullity(A, UtilEjml.EPS * 100.0);
    }

    public static int nullity(DenseMatrix64F A, double threshold) {
        SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd(A.numRows, A.numCols, false, false, true);
        if (svd.inputModified()) {
            A = A.copy();
        }
        if (!svd.decompose((Matrix)A)) {
            throw new RuntimeException("Decomposition failed");
        }
        return SingularOps.nullity(svd, threshold);
    }
}

