/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import org.ejml.alg.dense.decompose.chol.CholeskyDecompositionInner_CD64;
import org.ejml.alg.dense.mult.CVectorVectorMult;
import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.data.ComplexMatrix64F;
import org.ejml.ops.CCommonOps;

public class CMatrixFeatures {
    public static boolean hasNaN(CD1Matrix64F m) {
        int length = m.getDataLength();
        for (int i = 0; i < length; ++i) {
            if (!Double.isNaN(m.data[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUncountable(CD1Matrix64F m) {
        int length = m.getDataLength();
        for (int i = 0; i < length; ++i) {
            double a = m.data[i];
            if (!Double.isNaN(a) && !Double.isInfinite(a)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEquals(CD1Matrix64F a, CD1Matrix64F b) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        int length = a.getDataLength();
        for (int i = 0; i < length; ++i) {
            if (a.data[i] == b.data[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(CD1Matrix64F a, CD1Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        if (tol == 0.0) {
            return CMatrixFeatures.isEquals(a, b);
        }
        int length = a.getDataLength();
        for (int i = 0; i < length; ++i) {
            if (tol >= Math.abs(a.data[i] - b.data[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentical(CD1Matrix64F a, CD1Matrix64F b, double tol) {
        if (a.numRows != b.numRows || a.numCols != b.numCols) {
            return false;
        }
        if (tol < 0.0) {
            throw new IllegalArgumentException("Tolerance must be greater than or equal to zero.");
        }
        int length = a.getDataLength();
        for (int i = 0; i < length; ++i) {
            double valA = a.data[i];
            double valB = b.data[i];
            double diff = Math.abs(valA - valB);
            if (tol >= diff) continue;
            if (Double.isNaN(valA)) {
                return Double.isNaN(valB);
            }
            if (Double.isInfinite(valA)) {
                return valA == valB;
            }
            return false;
        }
        return true;
    }

    public static boolean isIdentity(ComplexMatrix64F mat, double tol) {
        Complex64F c = new Complex64F();
        for (int i = 0; i < mat.getNumRows(); ++i) {
            for (int j = 0; j < mat.getNumCols(); ++j) {
                mat.get(i, j, c);
                if (i == j) {
                    if (!(Math.abs(c.real - 1.0) <= tol)) {
                        return false;
                    }
                    if (Math.abs(c.imaginary) <= tol) continue;
                    return false;
                }
                if (!(Math.abs(c.real) <= tol)) {
                    return false;
                }
                if (Math.abs(c.imaginary) <= tol) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isHermitian(CDenseMatrix64F Q, double tol) {
        if (Q.numCols != Q.numRows) {
            return false;
        }
        Complex64F a = new Complex64F();
        Complex64F b = new Complex64F();
        for (int i = 0; i < Q.numCols; ++i) {
            for (int j = i + 1; j < Q.numCols; ++j) {
                Q.get(i, j, a);
                Q.get(j, i, b);
                if (Math.abs(a.real - b.real) > tol) {
                    return false;
                }
                if (!(Math.abs(a.imaginary + b.imaginary) > tol)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isUnitary(CDenseMatrix64F Q, double tol) {
        if (Q.numRows < Q.numCols) {
            throw new IllegalArgumentException("The number of rows must be more than or equal to the number of columns");
        }
        Complex64F prod = new Complex64F();
        CDenseMatrix64F[] u = CCommonOps.columnsToVector(Q, null);
        for (int i = 0; i < u.length; ++i) {
            CDenseMatrix64F a = u[i];
            CVectorVectorMult.innerProdH(a, a, prod);
            if (Math.abs(prod.real - 1.0) > tol) {
                return false;
            }
            if (Math.abs(prod.imaginary) > tol) {
                return false;
            }
            for (int j = i + 1; j < u.length; ++j) {
                CVectorVectorMult.innerProdH(a, u[j], prod);
                if (prod.getMagnitude2() <= tol * tol) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isPositiveDefinite(CDenseMatrix64F A) {
        if (A.numCols != A.numRows) {
            return false;
        }
        CholeskyDecompositionInner_CD64 chol = new CholeskyDecompositionInner_CD64(true);
        if (chol.inputModified()) {
            A = A.copy();
        }
        return chol.decompose(A);
    }
}

