/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose;

import org.ejml.data.CDenseMatrix64F;
import org.ejml.ops.CCommonOps;

public class UtilDecompositons_CD64 {
    public static CDenseMatrix64F checkIdentity(CDenseMatrix64F A, int numRows, int numCols) {
        if (A == null) {
            return CCommonOps.identity(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        CCommonOps.setIdentity(A);
        return A;
    }

    public static CDenseMatrix64F checkZeros(CDenseMatrix64F A, int numRows, int numCols) {
        if (A == null) {
            return new CDenseMatrix64F(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        A.zero();
        return A;
    }

    public static CDenseMatrix64F checkZerosLT(CDenseMatrix64F A, int numRows, int numCols) {
        if (A == null) {
            return new CDenseMatrix64F(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        for (int i = 0; i < A.numRows; ++i) {
            int index = i * A.numCols * 2;
            int end = index + Math.min(i, A.numCols) * 2;
            while (index < end) {
                A.data[index++] = 0.0;
            }
        }
        return A;
    }

    public static CDenseMatrix64F checkZerosUT(CDenseMatrix64F A, int numRows, int numCols) {
        if (A == null) {
            return new CDenseMatrix64F(numRows, numCols);
        }
        if (numRows != A.numRows || numCols != A.numCols) {
            throw new IllegalArgumentException("Input is not " + numRows + " x " + numCols + " matrix");
        }
        int maxRows = Math.min(A.numRows, A.numCols);
        for (int i = 0; i < maxRows; ++i) {
            int index = (i * A.numCols + i + 1) * 2;
            int end = (i * A.numCols + A.numCols) * 2;
            while (index < end) {
                A.data[index++] = 0.0;
            }
        }
        return A;
    }
}

