/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.linsol.qr;

import org.ejml.data.FMatrix;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.NormOps_FDRM;
import org.ejml.dense.row.decomposition.qr.QRColPivDecompositionHouseholderColumn_FDRM;
import org.ejml.interfaces.SolveNullSpace;

public class SolveNullSpaceQRP_FDRM
implements SolveNullSpace<FMatrixRMaj> {
    CustomizedQRP decomposition = new CustomizedQRP();
    FMatrixRMaj Q = new FMatrixRMaj(1, 1);

    public boolean process(FMatrixRMaj A, int numSingularValues, FMatrixRMaj nullspace) {
        this.decomposition.decompose(A);
        if (A.numRows > A.numCols) {
            this.Q.reshape(A.numCols, Math.min(A.numRows, A.numCols));
            this.decomposition.getQ(this.Q, true);
        } else {
            this.Q.reshape(A.numCols, A.numCols);
            this.decomposition.getQ(this.Q, false);
        }
        nullspace.reshape(this.Q.numRows, numSingularValues);
        CommonOps_FDRM.extract((FMatrix)this.Q, 0, this.Q.numRows, this.Q.numCols - numSingularValues, this.Q.numCols, (FMatrix)nullspace, 0, 0);
        return true;
    }

    private float check(FMatrixRMaj A, FMatrixRMaj nullspace) {
        FMatrixRMaj r = new FMatrixRMaj(A.numRows, nullspace.numCols);
        CommonOps_FDRM.mult((FMatrix1Row)A, (FMatrix1Row)nullspace, (FMatrix1Row)r);
        return NormOps_FDRM.normF((FMatrixD1)r);
    }

    public boolean inputModified() {
        return this.decomposition.inputModified();
    }

    public FMatrixRMaj getQ() {
        return this.Q;
    }

    private static class CustomizedQRP
    extends QRColPivDecompositionHouseholderColumn_FDRM {
        private CustomizedQRP() {
        }

        @Override
        protected void convertToColumnMajor(FMatrixRMaj A) {
            for (int x = 0; x < this.numCols; ++x) {
                System.arraycopy(A.data, x * A.numCols, this.dataQR[x], 0, this.numRows);
            }
        }

        @Override
        public boolean decompose(FMatrixRMaj A) {
            this.setExpectedMaxSize(A.numCols, A.numRows);
            this.convertToColumnMajor(A);
            this.setupPivotInfo();
            for (int j = 0; j < this.minLength; ++j) {
                if (j > 0) {
                    this.updateNorms(j);
                }
                this.swapColumns(j);
                if (!this.householderPivot(j)) break;
                this.updateA(j);
                this.rank = j + 1;
            }
            return true;
        }
    }
}

