/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRBlock;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRBlock;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.CovarianceRandomDraw_DDRM;
import org.ejml.dense.row.CovarianceRandomDraw_FDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.ejml.dense.row.RandomMatrices_FDRM;
import org.ejml.ops.ConvertDMatrixStruct;
import org.ejml.ops.ConvertFMatrixStruct;
import org.ejml.simple.SimpleBase;

public class SimpleMatrix
extends SimpleBase<SimpleMatrix> {
    public static final int END = Integer.MAX_VALUE;

    public SimpleMatrix(int numRows, int numCols, boolean rowMajor, double ... data) {
        this.mat = new DMatrixRMaj(numRows, numCols, rowMajor, data);
    }

    public SimpleMatrix(int numRows, int numCols, boolean rowMajor, float ... data) {
        this.mat = new FMatrixRMaj(numRows, numCols, rowMajor, data);
    }

    public SimpleMatrix(double[][] data) {
        this.mat = new DMatrixRMaj(data);
    }

    public SimpleMatrix(int numRows, int numCols) {
        this.mat = new DMatrixRMaj(numRows, numCols);
    }

    public SimpleMatrix(int numRows, int numCols, Class type) {
        this.mat = type == DMatrixRMaj.class ? new DMatrixRMaj(numRows, numCols) : new FMatrixRMaj(numRows, numCols);
    }

    public SimpleMatrix(SimpleMatrix orig) {
        this.mat = orig.mat.copy();
    }

    public SimpleMatrix(Matrix orig) {
        if (orig instanceof DMatrixRBlock) {
            DMatrixRMaj a = new DMatrixRMaj(orig.getNumRows(), orig.getNumCols());
            ConvertDMatrixStruct.convert((DMatrixRBlock)((DMatrixRBlock)orig), (DMatrixRMaj)a);
            this.mat = a;
        } else if (orig instanceof FMatrixRBlock) {
            FMatrixRMaj a = new FMatrixRMaj(orig.getNumRows(), orig.getNumCols());
            ConvertFMatrixStruct.convert((FMatrixRBlock)((FMatrixRBlock)orig), (FMatrixRMaj)a);
            this.mat = a;
        } else {
            this.mat = orig.copy();
        }
    }

    public SimpleMatrix() {
    }

    public static SimpleMatrix wrap(Matrix internalMat) {
        SimpleMatrix ret = new SimpleMatrix();
        ret.mat = internalMat;
        return ret;
    }

    public static SimpleMatrix identity(int width) {
        SimpleMatrix ret = new SimpleMatrix(width, width);
        CommonOps_DDRM.setIdentity((DMatrix1Row)((DMatrixRMaj)ret.mat));
        return ret;
    }

    public static SimpleMatrix identity(int width, Class type) {
        SimpleMatrix ret = new SimpleMatrix(width, width, type);
        if (type == DMatrixRMaj.class) {
            CommonOps_DDRM.setIdentity((DMatrix1Row)((DMatrixRMaj)ret.mat));
        } else {
            CommonOps_FDRM.setIdentity((FMatrix1Row)((FMatrixRMaj)ret.mat));
        }
        return ret;
    }

    public static SimpleMatrix diag(double ... vals) {
        DMatrixRMaj m = CommonOps_DDRM.diag((double[])vals);
        SimpleMatrix ret = SimpleMatrix.wrap((Matrix)m);
        return ret;
    }

    public static SimpleMatrix diag(Class type, double ... vals) {
        DMatrixRMaj m;
        if (type == DMatrixRMaj.class) {
            m = CommonOps_DDRM.diag((double[])vals);
        } else {
            float[] f = new float[vals.length];
            for (int i = 0; i < f.length; ++i) {
                f[i] = (float)vals[i];
            }
            m = CommonOps_FDRM.diag((float[])f);
        }
        SimpleMatrix ret = SimpleMatrix.wrap((Matrix)m);
        return ret;
    }

    public static SimpleMatrix random64(int numRows, int numCols, double minValue, double maxValue, Random rand) {
        SimpleMatrix ret = new SimpleMatrix(numRows, numCols);
        RandomMatrices_DDRM.fillUniform((DMatrixD1)((DMatrixRMaj)ret.mat), (double)minValue, (double)maxValue, (Random)rand);
        return ret;
    }

    public static SimpleMatrix random32(int numRows, int numCols, float minValue, float maxValue, Random rand) {
        SimpleMatrix ret = new SimpleMatrix(numRows, numCols, FMatrixRMaj.class);
        RandomMatrices_FDRM.fillUniform((FMatrixD1)((FMatrixRMaj)ret.mat), (float)minValue, (float)maxValue, (Random)rand);
        return ret;
    }

    public static SimpleMatrix randomNormal(SimpleMatrix covariance, Random random) {
        SimpleMatrix found = new SimpleMatrix(covariance.numRows(), 1);
        if (covariance.bits() == 64) {
            CovarianceRandomDraw_DDRM draw = new CovarianceRandomDraw_DDRM(random, (DMatrixRMaj)covariance.getMatrix());
            draw.next((DMatrixRMaj)found.getMatrix());
        } else {
            CovarianceRandomDraw_FDRM draw = new CovarianceRandomDraw_FDRM(random, (FMatrixRMaj)covariance.getMatrix());
            draw.next((FMatrixRMaj)found.getMatrix());
        }
        return found;
    }

    @Override
    protected SimpleMatrix createMatrix(int numRows, int numCols) {
        return new SimpleMatrix(numRows, numCols, this.mat.getClass());
    }
}

