/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.simple;

import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.ejml.UtilEjml;
import org.ejml.data.CMatrixD1;
import org.ejml.data.CMatrixRMaj;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixIterator;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparse;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.FMatrix;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparse;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.data.MatrixType;
import org.ejml.data.ReshapeMatrix;
import org.ejml.data.SingularMatrixException;
import org.ejml.data.ZMatrixD1;
import org.ejml.data.ZMatrixRMaj;
import org.ejml.dense.row.CommonOps_CDRM;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.CommonOps_ZDRM;
import org.ejml.equation.Equation;
import org.ejml.ops.ConvertMatrixType;
import org.ejml.ops.DConvertMatrixStruct;
import org.ejml.ops.FConvertMatrixStruct;
import org.ejml.ops.MatrixIO;
import org.ejml.simple.AutomaticSimpleMatrixConvert;
import org.ejml.simple.ConstMatrix;
import org.ejml.simple.ConvertToDenseException;
import org.ejml.simple.ConvertToImaginaryException;
import org.ejml.simple.SimpleEVD;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleOperations;
import org.ejml.simple.SimpleSVD;
import org.ejml.simple.ops.SimpleOperations_CDRM;
import org.ejml.simple.ops.SimpleOperations_DDRM;
import org.ejml.simple.ops.SimpleOperations_DSCC;
import org.ejml.simple.ops.SimpleOperations_FDRM;
import org.ejml.simple.ops.SimpleOperations_FSCC;
import org.ejml.simple.ops.SimpleOperations_ZDRM;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleBase<T extends SimpleBase<T>>
implements ConstMatrix<T>,
Serializable {
    static final long serialVersionUID = 2342556642L;
    protected Matrix mat;
    protected SimpleOperations ops;
    protected transient AutomaticSimpleMatrixConvert convertType = new AutomaticSimpleMatrixConvert();

    protected SimpleBase(int numRows, int numCols) {
        this.setMatrix((Matrix)new DMatrixRMaj(numRows, numCols));
    }

    protected SimpleBase() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.convertType = new AutomaticSimpleMatrixConvert();
    }

    protected abstract T createMatrix(int var1, int var2, MatrixType var3);

    protected T createRealMatrix(int numRows, int numCols) {
        MatrixType type = this.getType().getBits() == 32 ? MatrixType.FDRM : MatrixType.DDRM;
        return this.createMatrix(numRows, numCols, type);
    }

    protected T createComplexMatrix(int numRows, int numCols) {
        MatrixType type = this.getType().getBits() == 32 ? MatrixType.CDRM : MatrixType.ZDRM;
        return this.createMatrix(numRows, numCols, type);
    }

    protected abstract T wrapMatrix(Matrix var1);

    public <InnerType extends Matrix> InnerType getMatrix() {
        return (InnerType)this.mat;
    }

    public DMatrixRMaj getDDRM() {
        return this.mat.getType() == MatrixType.DDRM ? (DMatrixRMaj)this.mat : (DMatrixRMaj)ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)MatrixType.DDRM);
    }

    public FMatrixRMaj getFDRM() {
        return this.mat.getType() == MatrixType.FDRM ? (FMatrixRMaj)this.mat : (FMatrixRMaj)ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)MatrixType.FDRM);
    }

    public ZMatrixRMaj getZDRM() {
        return this.mat.getType() == MatrixType.ZDRM ? (ZMatrixRMaj)this.mat : (ZMatrixRMaj)ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)MatrixType.ZDRM);
    }

    public CMatrixRMaj getCDRM() {
        return this.mat.getType() == MatrixType.CDRM ? (CMatrixRMaj)this.mat : (CMatrixRMaj)ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)MatrixType.CDRM);
    }

    public DMatrixSparseCSC getDSCC() {
        return this.mat.getType() == MatrixType.DSCC ? (DMatrixSparseCSC)this.mat : (DMatrixSparseCSC)ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)MatrixType.DSCC);
    }

    public FMatrixSparseCSC getFSCC() {
        return this.mat.getType() == MatrixType.FSCC ? (FMatrixSparseCSC)this.mat : (FMatrixSparseCSC)ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)MatrixType.FSCC);
    }

    protected static SimpleOperations lookupOps(MatrixType type) {
        SimpleOperations<DMatrixRMaj> simpleOperations;
        switch (type) {
            case DDRM: {
                simpleOperations = new SimpleOperations_DDRM();
                break;
            }
            case FDRM: {
                simpleOperations = new SimpleOperations_FDRM();
                break;
            }
            case ZDRM: {
                simpleOperations = new SimpleOperations_ZDRM();
                break;
            }
            case CDRM: {
                simpleOperations = new SimpleOperations_CDRM();
                break;
            }
            case DSCC: {
                simpleOperations = new SimpleOperations_DSCC();
                break;
            }
            case FSCC: {
                simpleOperations = new SimpleOperations_FSCC();
                break;
            }
            default: {
                throw new RuntimeException("Unknown Matrix Type. " + type);
            }
        }
        return simpleOperations;
    }

    @Override
    public T transpose() {
        T ret = this.createMatrix(this.mat.getNumCols(), this.mat.getNumRows(), this.mat.getType());
        this.ops.transpose(this.mat, ((SimpleBase)ret).mat);
        return ret;
    }

    @Override
    public T transposeConjugate() {
        if (this.getType().isReal()) {
            return (T)this.transpose();
        }
        T ret = this.createMatrix(this.mat.getNumCols(), this.mat.getNumRows(), this.mat.getType());
        if (this.getType().getBits() == 32) {
            CommonOps_CDRM.transposeConjugate((CMatrixRMaj)this.getCDRM(), (CMatrixRMaj)((SimpleBase)ret).getCDRM());
        } else {
            CommonOps_ZDRM.transposeConjugate((ZMatrixRMaj)this.getZDRM(), (ZMatrixRMaj)((SimpleBase)ret).getZDRM());
        }
        return ret;
    }

    @Override
    public T mult(ConstMatrix<?> _B) {
        Method m;
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        if (this.mat.getType() != B.getType() && (m = this.findAlternative("mult", this.mat, B.mat, this.convertType.commonType.getClassType())) != null) {
            T ret = this.wrapMatrix(this.convertType.commonType.create(1, 1));
            this.invoke(m, this.mat, B.mat, ((SimpleBase)ret).mat);
            return ret;
        }
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        T ret = ((SimpleBase)A).createMatrix(this.mat.getNumRows(), B.getMatrix().getNumCols(), ((SimpleBase)A).getType());
        ((SimpleBase)A).ops.mult(((SimpleBase)A).mat, B.mat, ((SimpleBase)ret).mat);
        return ret;
    }

    @Override
    public T kron(ConstMatrix<?> _B) {
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        T ret = ((SimpleBase)A).createMatrix(this.mat.getNumRows() * B.numRows(), this.mat.getNumCols() * B.numCols(), ((SimpleBase)A).getType());
        ((SimpleBase)A).ops.kron(((SimpleBase)A).mat, B.mat, ((SimpleBase)ret).mat);
        return ret;
    }

    @Override
    public T plus(ConstMatrix<?> _B) {
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        T ret = ((SimpleBase)A).createMatrix(this.mat.getNumRows(), this.mat.getNumCols(), ((SimpleBase)A).getType());
        ((SimpleBase)A).ops.plus(((SimpleBase)A).mat, B.mat, ((SimpleBase)ret).mat);
        return ret;
    }

    @Override
    public T minus(ConstMatrix<?> _B) {
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        ConstMatrix ret = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.minus(((SimpleBase)A).mat, B.mat, ((SimpleBase)ret).mat);
        return (T)ret;
    }

    @Override
    public T minus(double b) {
        ConstMatrix ret = this.createLike();
        this.ops.minus(this.mat, b, ((SimpleBase)ret).mat);
        return (T)ret;
    }

    @Override
    public T minusComplex(double real, double imag) {
        try {
            ConstMatrix ret = this.createLike();
            this.ops.minusComplex(this.mat, real, imag, ((SimpleBase)ret).getMatrix());
            return (T)ret;
        }
        catch (ConvertToImaginaryException e) {
            T converted = this.createComplexMatrix(1, 1);
            ((SimpleBase)converted).setMatrix(ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)((SimpleBase)converted).getType()));
            return (T)((SimpleBase)converted).minusComplex(real, imag);
        }
    }

    @Override
    public T plus(double b) {
        ConstMatrix ret = this.createLike();
        this.ops.plus(this.mat, b, ((SimpleBase)ret).mat);
        return (T)ret;
    }

    @Override
    public T plusComplex(double real, double imag) {
        try {
            ConstMatrix ret = this.createLike();
            this.ops.plusComplex(this.mat, real, imag, ((SimpleBase)ret).getMatrix());
            return (T)ret;
        }
        catch (ConvertToImaginaryException e) {
            T converted = this.createComplexMatrix(1, 1);
            ((SimpleBase)converted).setMatrix(ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)((SimpleBase)converted).getType()));
            return (T)((SimpleBase)converted).plusComplex(real, imag);
        }
    }

    @Override
    public T plus(double beta, ConstMatrix<?> _B) {
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        ConstMatrix ret = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.plus(((SimpleBase)A).mat, beta, B.mat, ((SimpleBase)ret).mat);
        return (T)ret;
    }

    @Override
    public double dot(ConstMatrix<?> _v) {
        SimpleBase<T> v = (SimpleBase)_v;
        this.convertType.specify(this, v);
        Object A = this.convertType.convert(this);
        v = this.convertType.convert(v);
        if (!this.isVector()) {
            throw new IllegalArgumentException("'this' matrix is not a vector.");
        }
        if (!v.isVector()) {
            throw new IllegalArgumentException("'v' matrix is not a vector.");
        }
        return ((SimpleBase)A).ops.dot(((SimpleBase)A).mat, v.getMatrix());
    }

    @Override
    public boolean isVector() {
        return this.mat.getNumRows() == 1 || this.mat.getNumCols() == 1;
    }

    @Override
    public T scale(double val) {
        ConstMatrix ret = this.createLike();
        this.ops.scale(this.mat, val, ((SimpleBase)ret).getMatrix());
        return (T)ret;
    }

    @Override
    public T scaleComplex(double real, double imag) {
        try {
            ConstMatrix ret = this.createLike();
            this.ops.scaleComplex(this.mat, real, imag, ((SimpleBase)ret).getMatrix());
            return (T)ret;
        }
        catch (ConvertToImaginaryException e) {
            T converted = this.createComplexMatrix(1, 1);
            ((SimpleBase)converted).setMatrix(ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)((SimpleBase)converted).getType()));
            return (T)((SimpleBase)converted).scaleComplex(real, imag);
        }
    }

    @Override
    public T divide(double val) {
        ConstMatrix ret = this.createLike();
        this.ops.divide(this.mat, val, ((SimpleBase)ret).getMatrix());
        return (T)ret;
    }

    @Override
    public T invert() {
        ConstMatrix ret = this.createLike();
        if (!this.ops.invert(this.mat, ((SimpleBase)ret).mat)) {
            throw new SingularMatrixException();
        }
        if (this.ops.hasUncountable(((SimpleBase)ret).mat)) {
            throw new SingularMatrixException("Solution contains uncountable numbers");
        }
        return (T)ret;
    }

    @Override
    public T pseudoInverse() {
        ConstMatrix ret = this.createLike();
        this.ops.pseudoInverse(this.mat, ((SimpleBase)ret).mat);
        return (T)ret;
    }

    @Override
    public T solve(ConstMatrix<?> _B) {
        Method m;
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        if (this.mat.getType() != B.getType() && (m = this.findAlternative("solve", this.mat, B.mat, this.convertType.commonType.getClassType())) != null) {
            T ret = this.wrapMatrix(this.convertType.commonType.create(1, 1));
            this.invoke(m, this.mat, B.mat, ((SimpleBase)ret).mat);
            return ret;
        }
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        T x = ((SimpleBase)A).createMatrix(this.mat.getNumCols(), B.getMatrix().getNumCols(), ((SimpleBase)A).getType());
        if (!((SimpleBase)A).ops.solve(((SimpleBase)A).mat, ((SimpleBase)x).mat, B.mat)) {
            throw new SingularMatrixException();
        }
        if (((SimpleBase)A).ops.hasUncountable(((SimpleBase)x).mat)) {
            throw new SingularMatrixException("Solution contains uncountable numbers");
        }
        return x;
    }

    public void setTo(T a) {
        if (((SimpleBase)a).getType() == this.getType()) {
            this.mat.setTo(((SimpleBase)a).getMatrix());
        } else {
            this.setMatrix(((SimpleBase)a).mat.copy());
        }
    }

    public void fill(double val) {
        try {
            this.ops.fill(this.mat, val);
        }
        catch (ConvertToDenseException e) {
            this.convertToDense();
            this.fill(val);
        }
    }

    public void fillComplex(double real, double imaginary) {
        if (this.getType().isReal()) {
            this.setMatrix(((SimpleBase)this.createComplexMatrix((int)this.getNumRows(), (int)this.getNumCols())).mat);
        }
        if (this.getType().getBits() == 32) {
            CommonOps_CDRM.fill((CMatrixD1)this.getCDRM(), (float)((float)real), (float)((float)imaginary));
        } else {
            CommonOps_ZDRM.fill((ZMatrixD1)this.getZDRM(), (double)real, (double)imaginary);
        }
    }

    public void zero() {
        this.fill(0.0);
    }

    @Override
    public double normF() {
        return this.ops.normF(this.mat);
    }

    @Override
    public double conditionP2() {
        return this.ops.conditionP2(this.mat);
    }

    @Override
    public double determinant() {
        double ret = this.ops.determinant(this.mat);
        if (UtilEjml.isUncountable((double)ret)) {
            return 0.0;
        }
        return ret;
    }

    @Override
    public Complex_F64 determinantComplex() {
        Complex_F64 ret = this.ops.determinantComplex(this.mat);
        if (UtilEjml.isUncountable((double)ret.real)) {
            ret.setTo(0.0, 0.0);
        }
        return ret;
    }

    @Override
    public double trace() {
        return this.ops.trace(this.mat);
    }

    @Override
    public Complex_F64 traceComplex() {
        return this.ops.traceComplex(this.mat);
    }

    public void reshape(int numRows, int numCols) {
        if (this.mat.getType().isFixed()) {
            throw new IllegalArgumentException("Can't reshape a fixed sized matrix");
        }
        ((ReshapeMatrix)this.mat).reshape(numRows, numCols);
    }

    public void set(int row, int col, double value) {
        this.ops.set(this.mat, row, col, value);
    }

    public void set(int index, double value) {
        if (this.mat.getType() == MatrixType.DDRM) {
            ((DMatrixRMaj)this.mat).set(index, value);
        } else if (this.mat.getType() == MatrixType.FDRM) {
            ((FMatrixRMaj)this.mat).set(index, (float)value);
        } else {
            throw new RuntimeException("Not supported yet for this matrix type");
        }
    }

    public void set(int row, int col, double real, double imaginary) {
        if (imaginary == 0.0) {
            this.set(row, col, real);
        } else {
            this.ops.set(this.mat, row, col, real, imaginary);
        }
    }

    public void set(int row, int col, Complex_F64 value) {
        this.set(row, col, value.real, value.imaginary);
    }

    public void setRow(int row, int startColumn, double ... values) {
        this.ops.setRow(this.mat, row, startColumn, values);
    }

    public void setRow(int row, ConstMatrix<?> src) {
        double[] vector;
        if (!src.isVector()) {
            throw new IllegalArgumentException("Input matrix must be a vector");
        }
        if (src.getNumElements() != this.numCols()) {
            throw new IllegalArgumentException("Number of elements must match number of columns. src=" + src.getNumElements() + " cols=" + this.numCols());
        }
        this.convertType.specify(this, src);
        if (this.convertType.commonType != this.getType()) {
            this.setMatrix(((SimpleBase)this.convertType.convert(this)).mat);
        }
        SimpleBase bsrc = (SimpleBase)src;
        double[] dArray = vector = src.getNumRows() < src.getNumCols() ? bsrc.ops.getRow(bsrc.mat, 0, 0, src.getNumElements()) : bsrc.ops.getColumn(bsrc.mat, 0, 0, src.getNumElements());
        if (src.getType().isReal() && !this.getType().isReal()) {
            vector = SimpleBase.vectorRealToComplex(vector);
        }
        this.setRow(row, 0, vector);
    }

    public void setColumn(int column, int startRow, double ... values) {
        this.ops.setColumn(this.mat, column, startRow, values);
    }

    public void setColumn(int column, ConstMatrix<?> src) {
        double[] vector;
        if (!src.isVector()) {
            throw new IllegalArgumentException("Input matrix must be a vector");
        }
        if (src.getNumElements() != this.numRows()) {
            throw new IllegalArgumentException("Number of elements must match number of rows. src=" + src.getNumElements() + " cols=" + this.numRows());
        }
        this.convertType.specify(this, src);
        if (this.convertType.commonType != this.getType()) {
            this.setMatrix(((SimpleBase)this.convertType.convert(this)).mat);
        }
        SimpleBase bsrc = (SimpleBase)src;
        double[] dArray = vector = src.getNumRows() < src.getNumCols() ? bsrc.ops.getRow(bsrc.mat, 0, 0, src.getNumElements()) : bsrc.ops.getColumn(bsrc.mat, 0, 0, src.getNumElements());
        if (src.getType().isReal() && !this.getType().isReal()) {
            vector = SimpleBase.vectorRealToComplex(vector);
        }
        this.setColumn(column, 0, vector);
    }

    private static double[] vectorRealToComplex(double[] input) {
        double[] output = new double[input.length * 2];
        for (int i = 0; i < input.length; ++i) {
            output[i * 2] = input[i];
            output[i * 2 + 1] = 0.0;
        }
        return output;
    }

    @Override
    public double get(int row, int col) {
        return this.ops.get(this.mat, row, col);
    }

    @Override
    public double get(int index) {
        MatrixType type = this.mat.getType();
        if (type.isReal()) {
            if (type.getBits() == 64) {
                return ((DMatrixRMaj)this.mat).data[index];
            }
            return ((FMatrixRMaj)this.mat).data[index];
        }
        throw new IllegalArgumentException("Complex matrix. Call get(int,Complex64F) instead");
    }

    @Override
    public void get(int row, int col, Complex_F64 output) {
        this.ops.get(this.mat, row, col, output);
    }

    @Override
    public double getReal(int row, int col) {
        return this.ops.getReal(this.mat, row, col);
    }

    @Override
    public double getImaginary(int row, int col) {
        return this.ops.getImaginary(this.mat, row, col);
    }

    @Override
    public int getIndex(int row, int col) {
        return row * this.mat.getNumCols() + col;
    }

    @Override
    public DMatrixIterator iterator(boolean rowMajor, int minRow, int minCol, int maxRow, int maxCol) {
        return new DMatrixIterator((DMatrixD1)((DMatrixRMaj)this.mat), rowMajor, minRow, minCol, maxRow, maxCol);
    }

    @Override
    public T copy() {
        ConstMatrix ret = this.createLike();
        ((SimpleBase)ret).getMatrix().setTo(this.getMatrix());
        return (T)ret;
    }

    @Deprecated
    public int numRows() {
        return this.mat.getNumRows();
    }

    @Deprecated
    public int numCols() {
        return this.mat.getNumCols();
    }

    @Override
    public int getNumRows() {
        return this.mat.getNumRows();
    }

    @Override
    public int getNumCols() {
        return this.mat.getNumCols();
    }

    @Override
    public void print() {
        this.mat.print();
    }

    @Override
    public void print(String format) {
        this.ops.print(System.out, this.mat, format);
    }

    @Override
    public double[][] toArray2() {
        double[][] array = new double[this.mat.getNumRows()][this.mat.getNumCols()];
        for (int r = 0; r < this.mat.getNumRows(); ++r) {
            for (int c = 0; c < this.mat.getNumCols(); ++c) {
                array[r][c] = this.get(r, c);
            }
        }
        return array;
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(stream);
        MatrixIO.print((PrintStream)p, (Matrix)this.mat);
        return stream.toString(StandardCharsets.UTF_8);
    }

    @Override
    public T extractMatrix(int y0, int y1, int x0, int x1) {
        if (y0 == Integer.MAX_VALUE) {
            y0 = this.mat.getNumRows();
        }
        if (y1 == Integer.MAX_VALUE) {
            y1 = this.mat.getNumRows();
        }
        if (x0 == Integer.MAX_VALUE) {
            x0 = this.mat.getNumCols();
        }
        if (x1 == Integer.MAX_VALUE) {
            x1 = this.mat.getNumCols();
        }
        T ret = this.createMatrix(y1 - y0, x1 - x0, this.mat.getType());
        this.ops.extract(this.mat, y0, y1, x0, x1, ((SimpleBase)ret).mat, 0, 0);
        return ret;
    }

    @Override
    public T extractVector(boolean extractRow, int element) {
        if (extractRow) {
            return (T)this.extractMatrix(element, element + 1, 0, Integer.MAX_VALUE);
        }
        return (T)this.extractMatrix(0, Integer.MAX_VALUE, element, element + 1);
    }

    @Override
    public T getRow(int row) {
        return (T)this.extractVector(true, row);
    }

    @Override
    public T getColumn(int col) {
        return (T)this.extractVector(false, col);
    }

    @Override
    public T diag() {
        return this.wrapMatrix(this.ops.diag(this.mat));
    }

    @Override
    public boolean isIdentical(ConstMatrix<?> _a, double tol) {
        SimpleBase a = (SimpleBase)_a;
        if (a.getType() != this.getType()) {
            return false;
        }
        return this.ops.isIdentical(this.mat, a.mat, tol);
    }

    @Override
    public boolean hasUncountable() {
        return this.ops.hasUncountable(this.mat);
    }

    public SimpleSVD<T> svd() {
        return new SimpleSVD(this.mat, false);
    }

    public SimpleSVD<T> svd(boolean compact) {
        return new SimpleSVD(this.mat, compact);
    }

    public SimpleEVD<T> eig() {
        return new SimpleEVD(this.mat);
    }

    public void insertIntoThis(int insertRow, int insertCol, T B) {
        this.convertType.specify(new ConstMatrix[]{this, B});
        B = this.convertType.convert((SimpleBase<?>)B);
        if (this.convertType.commonType == this.getType()) {
            this.insert(((SimpleBase)B).mat, this.mat, insertRow, insertCol);
        } else {
            Object A = this.convertType.convert(this);
            ((SimpleBase)A).insert(((SimpleBase)B).mat, ((SimpleBase)A).mat, insertRow, insertCol);
            this.setMatrix(((SimpleBase)A).mat);
        }
    }

    void insert(Matrix src, Matrix dst, int destY0, int destX0) {
        this.ops.extract(src, 0, src.getNumRows(), 0, src.getNumCols(), dst, destY0, destX0);
    }

    @Override
    public T combine(int insertRow, int insertCol, ConstMatrix<?> _B) {
        ConstMatrix ret;
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        if (insertRow == Integer.MAX_VALUE) {
            insertRow = this.mat.getNumRows();
        }
        if (insertCol == Integer.MAX_VALUE) {
            insertCol = this.mat.getNumCols();
        }
        int maxRow = insertRow + B.numRows();
        int maxCol = insertCol + B.numCols();
        if (maxRow > this.mat.getNumRows() || maxCol > this.mat.getNumCols()) {
            int M = Math.max(maxRow, this.mat.getNumRows());
            int N = Math.max(maxCol, this.mat.getNumCols());
            ret = ((SimpleBase)A).createMatrix(M, N, ((SimpleBase)A).getType());
            ((SimpleBase)ret).insertIntoThis(0, 0, A);
        } else {
            ret = ((SimpleBase)A).copy();
        }
        ((SimpleBase)ret).insertIntoThis(insertRow, insertCol, B);
        return (T)ret;
    }

    @Override
    public double elementMax() {
        return this.ops.elementMax(this.mat);
    }

    @Override
    public double elementMin() {
        return this.ops.elementMin(this.mat);
    }

    @Override
    public double elementMaxAbs() {
        return this.ops.elementMaxAbs(this.mat);
    }

    @Override
    public double elementMinAbs() {
        return this.ops.elementMinAbs(this.mat);
    }

    @Override
    public double elementSum() {
        return this.ops.elementSum(this.mat);
    }

    @Override
    public Complex_F64 elementSumComplex() {
        Complex_F64 sum = new Complex_F64();
        this.ops.elementSumComplex(this.mat, sum);
        return sum;
    }

    @Override
    public T elementMult(ConstMatrix<?> _B) {
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        ConstMatrix c = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.elementMult(((SimpleBase)A).mat, B.mat, ((SimpleBase)c).mat);
        return (T)c;
    }

    @Override
    public T elementDiv(ConstMatrix<?> _B) {
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        ConstMatrix c = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.elementDiv(((SimpleBase)A).mat, B.mat, ((SimpleBase)c).mat);
        return (T)c;
    }

    @Override
    public T elementPower(ConstMatrix<?> _B) {
        SimpleBase<T> B = (SimpleBase)_B;
        this.convertType.specify(this, B);
        Object A = this.convertType.convert(this);
        B = this.convertType.convert(B);
        ConstMatrix c = ((SimpleBase)A).createLike();
        ((SimpleBase)A).ops.elementPower(((SimpleBase)A).mat, B.mat, ((SimpleBase)c).mat);
        return (T)c;
    }

    @Override
    public T elementPower(double b) {
        ConstMatrix c = this.createLike();
        this.ops.elementPower(this.mat, b, ((SimpleBase)c).mat);
        return (T)c;
    }

    @Override
    public T elementExp() {
        ConstMatrix c = this.createLike();
        this.ops.elementExp(this.mat, ((SimpleBase)c).mat);
        return (T)c;
    }

    @Override
    public T elementLog() {
        ConstMatrix c = this.createLike();
        this.ops.elementLog(this.mat, ((SimpleBase)c).mat);
        return (T)c;
    }

    @Override
    public T elementOp(SimpleOperations.ElementOpReal op) {
        ConstMatrix c = this.createLike();
        this.ops.elementOp(this.mat, op, ((SimpleBase)c).mat);
        return (T)c;
    }

    @Override
    public T elementOp(SimpleOperations.ElementOpComplex op) {
        ConstMatrix c = this.createLike();
        try {
            this.ops.elementOp(this.mat, op, ((SimpleBase)c).mat);
        }
        catch (ConvertToImaginaryException e) {
            T converted = this.createComplexMatrix(1, 1);
            ((SimpleBase)converted).setMatrix(ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)((SimpleBase)converted).getType()));
            return (T)((SimpleBase)converted).elementOp(op);
        }
        return (T)c;
    }

    @Override
    public T negative() {
        ConstMatrix A = this.copy();
        this.ops.changeSign(((SimpleBase)A).mat);
        return (T)A;
    }

    @Override
    public T conjugate() {
        ConstMatrix A = this.copy();
        if (((SimpleBase)A).getType().isReal()) {
            return (T)A;
        }
        if (((SimpleBase)A).getType().getBits() == 32) {
            CommonOps_CDRM.conjugate((CMatrixD1)this.getCDRM(), (CMatrixRMaj)((SimpleBase)A).getCDRM());
        } else {
            CommonOps_ZDRM.conjugate((ZMatrixD1)this.getZDRM(), (ZMatrixRMaj)((SimpleBase)A).getZDRM());
        }
        return (T)A;
    }

    @Override
    public T magnitude() {
        T A = this.createRealMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.getType().isReal()) {
            if (this.getType().getBits() == 32) {
                CommonOps_FDRM.abs((FMatrixD1)this.getFDRM(), (FMatrixD1)((SimpleBase)A).getFDRM());
            } else {
                CommonOps_DDRM.abs((DMatrixD1)this.getDDRM(), (DMatrixD1)((SimpleBase)A).getDDRM());
            }
        } else if (this.getType().getBits() == 32) {
            CommonOps_CDRM.magnitude((CMatrixD1)this.getCDRM(), (FMatrixRMaj)((SimpleBase)A).getFDRM());
        } else {
            CommonOps_ZDRM.magnitude((ZMatrixD1)this.getZDRM(), (DMatrixRMaj)((SimpleBase)A).getDDRM());
        }
        return A;
    }

    public void equation(String equation, Object ... variables) {
        if (variables.length >= 25) {
            throw new IllegalArgumentException("Too many variables!  At most 25");
        }
        if (!(this.mat instanceof DMatrixRMaj)) {
            return;
        }
        Equation eq = new Equation();
        String nameThis = "A";
        int offset = 0;
        if (variables.length > 0 && variables[0] instanceof String) {
            nameThis = (String)variables[0];
            offset = 1;
            if (variables.length % 2 != 1) {
                throw new IllegalArgumentException("Expected and odd length for variables");
            }
        } else if (variables.length % 2 != 0) {
            throw new IllegalArgumentException("Expected and even length for variables");
        }
        eq.alias((DMatrixRMaj)this.mat, nameThis);
        for (int i = offset; i < variables.length; i += 2) {
            Object object = variables[i + 1];
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("String expected at variables index " + i);
            }
            String name = (String)object;
            Object o = variables[i];
            if (SimpleBase.class.isAssignableFrom(o.getClass())) {
                eq.alias(((SimpleBase)o).getDDRM(), name);
                continue;
            }
            if (o instanceof DMatrixRMaj) {
                eq.alias((DMatrixRMaj)o, name);
                continue;
            }
            if (o instanceof Double) {
                eq.alias((Double)o, name);
                continue;
            }
            if (o instanceof Integer) {
                eq.alias((Integer)o, name);
                continue;
            }
            String type = o.getClass().getSimpleName();
            throw new IllegalArgumentException("Variable type not supported by Equation! " + type);
        }
        if (!((String)equation).contains("=")) {
            equation = nameThis + " = " + (String)equation;
        }
        eq.process((String)equation);
    }

    @Override
    public void saveToFileCSV(String fileName) throws IOException {
        MatrixIO.saveDenseCSV((DMatrix)((DMatrixRMaj)this.mat), (String)fileName);
    }

    @Override
    public void saveToMatrixMarket(String fileName) throws IOException {
        block9: {
            String format = ".15e";
            try (FileWriter writer = new FileWriter(fileName, StandardCharsets.UTF_8);){
                if (this.mat instanceof DMatrixRMaj) {
                    MatrixIO.saveMatrixMarket((DMatrixRMaj)((DMatrixRMaj)this.mat), (String)".15e", (Writer)writer);
                    break block9;
                }
                if (this.mat instanceof FMatrixRMaj) {
                    MatrixIO.saveMatrixMarket((FMatrixRMaj)((FMatrixRMaj)this.mat), (String)".15e", (Writer)writer);
                    break block9;
                }
                if (this.mat instanceof DMatrixSparseCSC) {
                    MatrixIO.saveMatrixMarket((DMatrixSparse)((DMatrixSparseCSC)this.mat), (String)".15e", (Writer)writer);
                    break block9;
                }
                if (this.mat instanceof FMatrixSparseCSC) {
                    MatrixIO.saveMatrixMarket((FMatrixSparse)((FMatrixSparseCSC)this.mat), (String)".15e", (Writer)writer);
                    break block9;
                }
                throw new IllegalArgumentException("Internal matrix type isn'y yet support for matrix market");
            }
        }
    }

    public T loadCSV(String fileName) throws IOException {
        DMatrix mat = MatrixIO.loadCSV((String)fileName, (boolean)true);
        T ret = this.createMatrix(1, 1, mat.getType());
        ((SimpleBase)ret).setMatrix((Matrix)mat);
        return ret;
    }

    @Override
    public boolean isInBounds(int row, int col) {
        return row >= 0 && col >= 0 && row < this.mat.getNumRows() && col < this.mat.getNumCols();
    }

    public void printDimensions() {
        System.out.println("[rows = " + this.numRows() + " , cols = " + this.numCols() + " ]");
    }

    @Override
    public int bits() {
        return this.mat.getType().getBits();
    }

    @Override
    public T concatColumns(ConstMatrix<?> ... matrices) {
        this.convertType.specify0(this, matrices);
        Object A = this.convertType.convert(this);
        int numCols = ((SimpleBase)A).numCols();
        int numRows = ((SimpleBase)A).numRows();
        for (int i = 0; i < matrices.length; ++i) {
            numRows = Math.max(numRows, matrices[i].getNumRows());
            numCols += matrices[i].getNumCols();
        }
        SimpleMatrix combined = SimpleMatrix.wrap(this.convertType.commonType.create(numRows, numCols));
        ((SimpleBase)A).ops.extract(((SimpleBase)A).mat, 0, ((SimpleBase)A).numRows(), 0, ((SimpleBase)A).numCols(), combined.mat, 0, 0);
        int col = ((SimpleBase)A).numCols();
        for (int i = 0; i < matrices.length; ++i) {
            Matrix m = ((SimpleBase)this.convertType.convert((SimpleBase)matrices[i])).mat;
            int cols = m.getNumCols();
            int rows = m.getNumRows();
            ((SimpleBase)A).ops.extract(m, 0, rows, 0, cols, combined.mat, 0, col);
            col += cols;
        }
        return (T)combined;
    }

    @Override
    public T concatRows(ConstMatrix<?> ... matrices) {
        this.convertType.specify0(this, matrices);
        Object A = this.convertType.convert(this);
        int numCols = ((SimpleBase)A).numCols();
        int numRows = ((SimpleBase)A).numRows();
        for (int i = 0; i < matrices.length; ++i) {
            numRows += matrices[i].getNumRows();
            numCols = Math.max(numCols, matrices[i].getNumCols());
        }
        SimpleMatrix combined = SimpleMatrix.wrap(this.convertType.commonType.create(numRows, numCols));
        ((SimpleBase)A).ops.extract(((SimpleBase)A).mat, 0, ((SimpleBase)A).numRows(), 0, ((SimpleBase)A).numCols(), combined.mat, 0, 0);
        int row = ((SimpleBase)A).numRows();
        for (int i = 0; i < matrices.length; ++i) {
            Matrix m = ((SimpleBase)this.convertType.convert((SimpleBase)matrices[i])).mat;
            int cols = m.getNumCols();
            int rows = m.getNumRows();
            ((SimpleBase)A).ops.extract(m, 0, rows, 0, cols, combined.mat, row, 0);
            row += rows;
        }
        return (T)combined;
    }

    @Override
    public T rows(int begin, int end) {
        return (T)this.extractMatrix(begin, end, 0, Integer.MAX_VALUE);
    }

    @Override
    public T cols(int begin, int end) {
        return (T)this.extractMatrix(0, Integer.MAX_VALUE, begin, end);
    }

    @Override
    public MatrixType getType() {
        return this.mat.getType();
    }

    @Override
    public T real() {
        T ret = this.createRealMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.mat.getType().isReal()) {
            return ((SimpleBase)ret).wrapMatrix(this.mat.copy());
        }
        if (this.mat.getType().getBits() == 32) {
            return ((SimpleBase)ret).wrapMatrix((Matrix)CommonOps_CDRM.real((CMatrixD1)((CMatrixD1)this.mat), null));
        }
        return ((SimpleBase)ret).wrapMatrix((Matrix)CommonOps_ZDRM.real((ZMatrixD1)((ZMatrixD1)this.mat), null));
    }

    @Override
    public T imaginary() {
        T ret = this.createRealMatrix(this.mat.getNumRows(), this.mat.getNumCols());
        if (this.mat.getType().isReal()) {
            return ((SimpleBase)ret).wrapMatrix(this.mat.createLike());
        }
        if (this.mat.getType().getBits() == 32) {
            return ((SimpleBase)ret).wrapMatrix((Matrix)CommonOps_CDRM.imaginary((CMatrixD1)((CMatrixD1)this.mat), null));
        }
        return ((SimpleBase)ret).wrapMatrix((Matrix)CommonOps_ZDRM.imaginary((ZMatrixD1)((ZMatrixD1)this.mat), null));
    }

    @Override
    public T createLike() {
        return this.createMatrix(this.numRows(), this.numCols(), this.getType());
    }

    protected void setMatrix(Matrix mat) {
        this.mat = mat;
        this.ops = SimpleBase.lookupOps(mat.getType());
    }

    @Nullable
    Method findAlternative(String method, Object ... arguments) {
        Method[] methods = this.ops.getClass().getMethods();
        for (int methodIdx = 0; methodIdx < methods.length; ++methodIdx) {
            Class<?>[] paramTypes;
            if (!methods[methodIdx].getName().equals(method) || (paramTypes = methods[methodIdx].getParameterTypes()).length != arguments.length) continue;
            boolean match = true;
            for (int j = 0; j < paramTypes.length; ++j) {
                if (arguments[j] instanceof Class) {
                    if (paramTypes[j] == arguments[j]) continue;
                    match = false;
                    break;
                }
                if (paramTypes[j] == arguments[j].getClass()) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return methods[methodIdx];
        }
        return null;
    }

    public void invoke(Method m, Object ... inputs) {
        try {
            m.invoke((Object)this.ops, inputs);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void convertToSparse() {
        switch (this.mat.getType()) {
            case DDRM: {
                DMatrixSparseCSC m = new DMatrixSparseCSC(this.mat.getNumRows(), this.mat.getNumCols());
                DConvertMatrixStruct.convert((DMatrixRMaj)((DMatrixRMaj)this.mat), (DMatrixSparseCSC)m, (double)0.0);
                this.setMatrix((Matrix)m);
                break;
            }
            case FDRM: {
                FMatrixSparseCSC m = new FMatrixSparseCSC(this.mat.getNumRows(), this.mat.getNumCols());
                FConvertMatrixStruct.convert((FMatrixRMaj)((FMatrixRMaj)this.mat), (FMatrixSparseCSC)m, (float)0.0f);
                this.setMatrix((Matrix)m);
                break;
            }
            case DSCC: 
            case FSCC: {
                break;
            }
            default: {
                throw new RuntimeException("Conversion not supported!");
            }
        }
    }

    public void convertToDense() {
        switch (this.mat.getType()) {
            case DSCC: {
                DMatrixRMaj m = new DMatrixRMaj(this.mat.getNumRows(), this.mat.getNumCols());
                DConvertMatrixStruct.convert((DMatrix)((DMatrix)this.mat), (DMatrix)m);
                this.setMatrix((Matrix)m);
                break;
            }
            case FSCC: {
                FMatrixRMaj m = new FMatrixRMaj(this.mat.getNumRows(), this.mat.getNumCols());
                FConvertMatrixStruct.convert((FMatrix)((FMatrix)this.mat), (FMatrix)m);
                this.setMatrix((Matrix)m);
                break;
            }
            case DDRM: 
            case FDRM: 
            case ZDRM: 
            case CDRM: {
                break;
            }
            default: {
                throw new RuntimeException("Not a sparse matrix!");
            }
        }
    }

    public void convertToComplex() {
        switch (this.mat.getType()) {
            case DDRM: {
                this.setMatrix(ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)MatrixType.ZDRM));
                break;
            }
            case FDRM: {
                this.setMatrix(ConvertMatrixType.convert((Matrix)this.mat, (MatrixType)MatrixType.CDRM));
                break;
            }
            case ZDRM: 
            case CDRM: {
                break;
            }
            default: {
                throw new RuntimeException("Conversion not supported!");
            }
        }
    }
}

