/*
 * Decompiled with CFR 0.152.
 */
package org.ekstazi.scalatest;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.ekstazi.asm.ClassReader;
import org.ekstazi.asm.ClassVisitor;
import org.ekstazi.asm.ClassWriter;
import org.ekstazi.asm.MethodVisitor;

public class ScalaTestCFT
implements ClassFileTransformer {
    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        if (string.startsWith("org/scalatest/tools/")) {
            ClassReader classReader = new ClassReader(byArray);
            ClassWriter classWriter = new ClassWriter(classReader, 1);
            ScalaTestClassVisitor scalaTestClassVisitor = new ScalaTestClassVisitor(string, (ClassVisitor)classWriter);
            classReader.accept((ClassVisitor)scalaTestClassVisitor, 0);
            return classWriter.toByteArray();
        }
        return null;
    }

    private static class ScalaTestMethodVisitor
    extends MethodVisitor {
        private final String mClassName;

        public ScalaTestMethodVisitor(String string, MethodVisitor methodVisitor) {
            super(327680, methodVisitor);
            this.mClassName = string;
        }

        public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
            if (n == 182 && string2.equals("newInstance") && (this.mClassName.contains("org/scalatest/tools/DiscoverySuite") || this.mClassName.contains("ScalaTestTask")) && string.equals("java/lang/Class")) {
                this.mv.visitMethodInsn(184, "org/ekstazi/scalatest/ScalaTestMonitor", "newInstance", "(Ljava/lang/Class;)Ljava/lang/Object;", false);
            } else {
                this.mv.visitMethodInsn(n, string, string2, string3, bl);
            }
        }
    }

    private static class ScalaTestClassVisitor
    extends ClassVisitor {
        private final String mClassName;

        public ScalaTestClassVisitor(String string, ClassVisitor classVisitor) {
            super(327680, classVisitor);
            this.mClassName = string;
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
            methodVisitor = new ScalaTestMethodVisitor(this.mClassName, methodVisitor);
            return methodVisitor;
        }
    }
}

