/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.persistence.file;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticmq.persistence.CreateQueueMetadata;
import org.elasticmq.persistence.DeadLettersQueue;
import org.elasticmq.persistence.QueueSorter$;
import org.elasticmq.util.Logging;
import org.joda.time.DateTime;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class QueueConfigUtil$
implements Logging {
    public static final QueueConfigUtil$ MODULE$ = new QueueConfigUtil$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        QueueConfigUtil$ queueConfigUtil$ = this;
        synchronized (queueConfigUtil$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    public List<CreateQueueMetadata> readPersistedQueuesFromPath(String queuesStoragePath) {
        return (List)Try$.MODULE$.apply((Function0 & Serializable)() -> ConfigFactory.parseFile((File)new File(queuesStoragePath))).map((Function1 & Serializable)persistedQueuesConfig -> MODULE$.readPersistedQueuesFromConfig((Config)persistedQueuesConfig)).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
    }

    public List<CreateQueueMetadata> readPersistedQueuesFromConfig(Config persistedQueuesConfig) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)persistedQueuesConfig.getObject("queues")).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Failed to extract queue configuration", ex);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalStateException(ex);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        scala.collection.immutable.Map value = (scala.collection.immutable.Map)success.value();
        List<CreateQueueMetadata> list = this.getQueuesFromConfig((scala.collection.immutable.Map<String, ConfigValue>)value);
        return list;
    }

    private List<CreateQueueMetadata> getQueuesFromConfig(scala.collection.immutable.Map<String, ConfigValue> queuesConfig) {
        List value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.getQueuesFromConfigUnsafe(queuesConfig));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Failed to create queues from config", ex);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalStateException(ex);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        List list = value = (List)success.value();
        return list;
    }

    private List<CreateQueueMetadata> getQueuesFromConfigUnsafe(scala.collection.immutable.Map<String, ConfigValue> queuesConfig) {
        String deadLettersQueueKey = "deadLettersQueue";
        long now = new DateTime().toInstant().getMillis();
        List unsortedQueues = ((IterableOnceOps)queuesConfig.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String n = (String)tuple2._1();
            ConfigValue v = (ConfigValue)tuple2._2();
            Config c = ((ConfigObject)v).toConfig();
            boolean isFifo = BoxesRunTime.unboxToBoolean((Object)QueueConfigUtil$.getOptionalBoolean$1(c, "fifo").getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            CreateQueueMetadata createQueueMetadata = new CreateQueueMetadata(MODULE$.addSuffixWhenFifoQueue(n, isFifo), QueueConfigUtil$.getOptionalDuration$1(c, "defaultVisibilityTimeout"), QueueConfigUtil$.getOptionalDuration$1(c, "delay"), QueueConfigUtil$.getOptionalDuration$1(c, "receiveMessageWait"), BoxesRunTime.unboxToLong((Object)QueueConfigUtil$.getOptionalLong$1(c, "created").getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now)), BoxesRunTime.unboxToLong((Object)QueueConfigUtil$.getOptionalLong$1(c, "lastModified").getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now)), (Option)(c.hasPath(deadLettersQueueKey) ? new Some((Object)new DeadLettersQueue(c.getString(new StringBuilder(5).append(deadLettersQueueKey).append(".name").toString()), c.getInt(new StringBuilder(16).append(deadLettersQueueKey).append(".maxReceiveCount").toString()))) : None$.MODULE$), isFifo, BoxesRunTime.unboxToBoolean((Object)QueueConfigUtil$.getOptionalBoolean$1(c, "contentBasedDeduplication").getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), QueueConfigUtil$.getOptionalString$1(c, "copyTo"), QueueConfigUtil$.getOptionalString$1(c, "moveTo"), QueueConfigUtil$.getOptionalTags$1(c, "tags"));
            return createQueueMetadata;
        })).toList();
        return QueueSorter$.MODULE$.sortCreateQueues(unsortedQueues);
    }

    private String addSuffixWhenFifoQueue(String queueName, boolean isFifo) {
        return isFifo && !queueName.endsWith(".fifo") ? new StringBuilder(5).append(queueName).append(".fifo").toString() : queueName;
    }

    private static final Option getOptionalBoolean$1(Config c, String k) {
        return c.hasPath(k) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)c.getBoolean(k))) : None$.MODULE$;
    }

    private static final Option getOptionalLong$1(Config c, String k) {
        return c.hasPath(k) ? new Some((Object)BoxesRunTime.boxToLong((long)c.getLong(k))) : None$.MODULE$;
    }

    private static final Option getOptionalDuration$1(Config c, String k) {
        return c.hasPath(k) ? new Some((Object)BoxesRunTime.boxToLong((long)c.getDuration(k, TimeUnit.SECONDS))) : None$.MODULE$;
    }

    private static final Option getOptionalString$1(Config c, String k) {
        return c.hasPath(k) ? new Some((Object)c.getString(k)).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$1)))) : None$.MODULE$;
    }

    private static final scala.collection.immutable.Map getOptionalTags$1(Config c, String k) {
        return c.hasPath(k) ? ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)c.getObject(k)).asScala()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)c.getString(new StringBuilder(11).append(k).append('.').append(key).toString()));
            return tuple22;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private QueueConfigUtil$() {
    }
}

