/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.persistence.file;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticmq.persistence.CreateQueueMetadata;
import org.elasticmq.persistence.CreateQueueMetadata$;
import org.elasticmq.persistence.DeadLettersQueue$;
import org.elasticmq.persistence.QueueSorter$;
import org.elasticmq.util.Logging;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class QueueConfigUtil$
implements LazyLogging,
Logging,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(QueueConfigUtil$.class.getDeclaredField("logger$lzy1"));
    private volatile transient Object logger$lzy1;
    public static final QueueConfigUtil$ MODULE$ = new QueueConfigUtil$();

    private QueueConfigUtil$() {
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogging.logger$((LazyLogging)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QueueConfigUtil$.class);
    }

    public List<CreateQueueMetadata> readPersistedQueuesFromPath(String queuesStoragePath) {
        return (List)Try$.MODULE$.apply(() -> QueueConfigUtil$.readPersistedQueuesFromPath$$anonfun$1(queuesStoragePath)).map((Function1 & Serializable)persistedQueuesConfig -> MODULE$.readPersistedQueuesFromConfig((Config)persistedQueuesConfig)).getOrElse(QueueConfigUtil$::readPersistedQueuesFromPath$$anonfun$3);
    }

    public List<CreateQueueMetadata> readPersistedQueuesFromConfig(Config persistedQueuesConfig) {
        Try try_ = Try$.MODULE$.apply(() -> QueueConfigUtil$.readPersistedQueuesFromConfig$$anonfun$1(persistedQueuesConfig));
        if (try_ instanceof Success) {
            scala.collection.immutable.Map value = (scala.collection.immutable.Map)((Success)try_).value();
            return this.getQueuesFromConfig((scala.collection.immutable.Map<String, ConfigValue>)value);
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            Logger LoggerImpl_this = this.logger();
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("Failed to extract queue configuration", ex);
            }
            throw new IllegalStateException(ex);
        }
        throw new MatchError((Object)try_);
    }

    private List<CreateQueueMetadata> getQueuesFromConfig(scala.collection.immutable.Map<String, ConfigValue> queuesConfig) {
        Try try_ = Try$.MODULE$.apply(() -> QueueConfigUtil$.getQueuesFromConfig$$anonfun$1(queuesConfig));
        if (try_ instanceof Success) {
            List value = (List)((Success)try_).value();
            return value;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            Logger LoggerImpl_this = this.logger();
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("Failed to create queues from config", ex);
            }
            throw new IllegalStateException(ex);
        }
        throw new MatchError((Object)try_);
    }

    private List<CreateQueueMetadata> getQueuesFromConfigUnsafe(scala.collection.immutable.Map<String, ConfigValue> queuesConfig) {
        String deadLettersQueueKey = "deadLettersQueue";
        long now = OffsetDateTime.now().toInstant().toEpochMilli();
        List unsortedQueues = ((IterableOnceOps)queuesConfig.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String n = (String)tuple2._1();
                ConfigValue v = (ConfigValue)tuple2._2();
                Config c = ((ConfigObject)v).toConfig();
                boolean isFifo = BoxesRunTime.unboxToBoolean((Object)this.getOptionalBoolean$1(c, "fifo").getOrElse(QueueConfigUtil$::$anonfun$2));
                return CreateQueueMetadata$.MODULE$.apply(this.addSuffixWhenFifoQueue(n, isFifo), this.getOptionalDuration$1(c, "defaultVisibilityTimeout"), this.getOptionalDuration$1(c, "delay"), this.getOptionalDuration$1(c, "receiveMessageWait"), BoxesRunTime.unboxToLong((Object)this.getOptionalLong$1(c, "created").getOrElse(() -> QueueConfigUtil$.$anonfun$1$$anonfun$1(now))), BoxesRunTime.unboxToLong((Object)this.getOptionalLong$1(c, "lastModified").getOrElse(() -> QueueConfigUtil$.$anonfun$1$$anonfun$2(now))), (Option)(c.hasPath(deadLettersQueueKey) ? Some$.MODULE$.apply((Object)DeadLettersQueue$.MODULE$.apply(c.getString(new StringBuilder(5).append(deadLettersQueueKey).append(".name").toString()), c.getInt(new StringBuilder(16).append(deadLettersQueueKey).append(".maxReceiveCount").toString()))) : None$.MODULE$), isFifo, BoxesRunTime.unboxToBoolean((Object)this.getOptionalBoolean$1(c, "contentBasedDeduplication").getOrElse(QueueConfigUtil$::$anonfun$1$$anonfun$3)), this.getOptionalString$1(c, "copyTo"), this.getOptionalString$1(c, "moveTo"), this.getOptionalTags$1(c, "tags"));
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        return QueueSorter$.MODULE$.sortCreateQueues(unsortedQueues);
    }

    private String addSuffixWhenFifoQueue(String queueName, boolean isFifo) {
        if (isFifo && !queueName.endsWith(".fifo")) {
            return new StringBuilder(5).append(queueName).append(".fifo").toString();
        }
        return queueName;
    }

    private static final Config readPersistedQueuesFromPath$$anonfun$1(String queuesStoragePath$1) {
        return ConfigFactory.parseFile((File)new File(queuesStoragePath$1));
    }

    private static final List readPersistedQueuesFromPath$$anonfun$3() {
        return package$.MODULE$.Nil();
    }

    private static final scala.collection.immutable.Map readPersistedQueuesFromConfig$$anonfun$1(Config persistedQueuesConfig$1) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)persistedQueuesConfig$1.getObject("queues")).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final List getQueuesFromConfig$$anonfun$1(scala.collection.immutable.Map queuesConfig$1) {
        return MODULE$.getQueuesFromConfigUnsafe((scala.collection.immutable.Map<String, ConfigValue>)queuesConfig$1);
    }

    private final Option getOptionalBoolean$1(Config c, String k) {
        if (c.hasPath(k)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)c.getBoolean(k)));
        }
        return None$.MODULE$;
    }

    private final Option getOptionalLong$1(Config c, String k) {
        if (c.hasPath(k)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)c.getLong(k)));
        }
        return None$.MODULE$;
    }

    private final Option getOptionalDuration$1(Config c, String k) {
        if (c.hasPath(k)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)c.getDuration(k, TimeUnit.SECONDS)));
        }
        return None$.MODULE$;
    }

    private final Option getOptionalString$1(Config c, String k) {
        if (c.hasPath(k)) {
            return Some$.MODULE$.apply((Object)c.getString(k)).filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1)));
        }
        return None$.MODULE$;
    }

    private final scala.collection.immutable.Map getOptionalTags$1(Config c, String k) {
        if (c.hasPath(k)) {
            return ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)c.getObject(k)).asScala()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)c.getString(new StringBuilder(11).append(k).append('.').append(key).toString()));
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final boolean $anonfun$2() {
        return false;
    }

    private static final long $anonfun$1$$anonfun$1(long now$2) {
        return now$2;
    }

    private static final long $anonfun$1$$anonfun$2(long now$3) {
        return now$3;
    }

    private static final boolean $anonfun$1$$anonfun$3() {
        return false;
    }
}

