/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.persistence.sql;

import java.io.Serializable;
import org.elasticmq.BinaryMessageAttribute;
import org.elasticmq.DeduplicationId;
import org.elasticmq.MessageAttribute;
import org.elasticmq.NeverReceived$;
import org.elasticmq.NumberMessageAttribute;
import org.elasticmq.OnDateTimeReceived;
import org.elasticmq.Received;
import org.elasticmq.StringMessageAttribute;
import org.elasticmq.TracingId;
import org.elasticmq.actor.queue.InternalMessage;
import org.elasticmq.persistence.sql.DBMessage;
import org.elasticmq.persistence.sql.package;
import org.elasticmq.persistence.sql.package$SerializableAttributeProtocol$;
import org.joda.time.DateTime;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple12;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scalikejdbc.WrappedResultSet;
import spray.json.package$;

public final class DBMessage$
implements Serializable {
    public static final DBMessage$ MODULE$ = new DBMessage$();

    public DBMessage apply(WrappedResultSet rs) {
        return new DBMessage(rs.string("message_id"), rs.bytes("delivery_receipts"), rs.long("next_delivery"), rs.bytes("content"), rs.bytes("attributes"), rs.long("created"), (Option<Object>)rs.longOpt("received"), rs.int("receive_count"), (Option<String>)rs.stringOpt("group_id"), (Option<String>)rs.stringOpt("deduplication_id"), (Option<String>)rs.stringOpt("tracing_id"), (Option<String>)rs.stringOpt("sequence_number"));
    }

    public DBMessage from(InternalMessage message) {
        None$ none$;
        List deliveryReceipts = message.deliveryReceipts().toList();
        List attributes = message.messageAttributes().toList().map((Function1 & Serializable)x0$1 -> {
            package.SerializableAttribute serializableAttribute;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String k = (String)tuple2._1();
            MessageAttribute v = (MessageAttribute)tuple2._2();
            MessageAttribute messageAttribute = v;
            if (messageAttribute instanceof StringMessageAttribute) {
                StringMessageAttribute stringMessageAttribute = (StringMessageAttribute)messageAttribute;
                String stringValue = stringMessageAttribute.stringValue();
                Option customType = stringMessageAttribute.customType();
                serializableAttribute = new package.SerializableAttribute(k, "String", stringValue, (Option<String>)customType);
                return serializableAttribute;
            } else if (messageAttribute instanceof NumberMessageAttribute) {
                NumberMessageAttribute numberMessageAttribute = (NumberMessageAttribute)messageAttribute;
                String stringValue = numberMessageAttribute.stringValue();
                Option customType = numberMessageAttribute.customType();
                serializableAttribute = new package.SerializableAttribute(k, "Number", stringValue, (Option<String>)customType);
                return serializableAttribute;
            } else {
                if (!(messageAttribute instanceof BinaryMessageAttribute)) throw new MatchError((Object)messageAttribute);
                BinaryMessageAttribute binaryMessageAttribute = (BinaryMessageAttribute)messageAttribute;
                serializableAttribute = new package.SerializableAttribute(k, "Binary", binaryMessageAttribute.asBase64(), (Option<String>)binaryMessageAttribute.customType());
            }
            return serializableAttribute;
        });
        Received received = message.firstReceive();
        if (NeverReceived$.MODULE$.equals(received)) {
            none$ = None$.MODULE$;
        } else if (received instanceof OnDateTimeReceived) {
            OnDateTimeReceived onDateTimeReceived = (OnDateTimeReceived)received;
            DateTime when = onDateTimeReceived.when();
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)when.toInstant().getMillis()));
        } else {
            throw new MatchError((Object)received);
        }
        None$ received2 = none$;
        Option deduplicationId = message.messageDeduplicationId().map((Function1 & Serializable)x$1 -> ((DeduplicationId)x$1).id());
        return new DBMessage(message.id(), package$.MODULE$.enrichAny((Object)deliveryReceipts).toJson(package$SerializableAttributeProtocol$.MODULE$.listFormat(package$SerializableAttributeProtocol$.MODULE$.StringJsonFormat())).toString().getBytes(), message.nextDelivery(), message.content().getBytes(), package$.MODULE$.enrichAny((Object)attributes).toJson(package$SerializableAttributeProtocol$.MODULE$.listFormat(package$SerializableAttributeProtocol$.MODULE$.colorFormat())).toString().getBytes(), message.created().toInstant().getMillis(), (Option<Object>)received2, message.receiveCount(), (Option<String>)message.messageGroupId(), (Option<String>)deduplicationId, (Option<String>)message.tracingId().map((Function1 & Serializable)x$2 -> ((TracingId)x$2).id()), (Option<String>)message.sequenceNumber());
    }

    public DBMessage apply(String messageId, byte[] deliveryReceipts, long nextDelivery, byte[] content, byte[] attributes, long created, Option<Object> received, int receiveCount, Option<String> groupId, Option<String> deduplicationId, Option<String> tracingId, Option<String> sequenceNumber) {
        return new DBMessage(messageId, deliveryReceipts, nextDelivery, content, attributes, created, received, receiveCount, groupId, deduplicationId, tracingId, sequenceNumber);
    }

    public Option<Tuple12<String, byte[], Object, byte[], byte[], Object, Option<Object>, Object, Option<String>, Option<String>, Option<String>, Option<String>>> unapply(DBMessage x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.messageId(), (Object)x$0.deliveryReceipts(), (Object)BoxesRunTime.boxToLong((long)x$0.nextDelivery()), (Object)x$0.content(), (Object)x$0.attributes(), (Object)BoxesRunTime.boxToLong((long)x$0.created()), x$0.received(), (Object)BoxesRunTime.boxToInteger((int)x$0.receiveCount()), x$0.groupId(), x$0.deduplicationId(), x$0.tracingId(), x$0.sequenceNumber()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DBMessage$.class);
    }

    private DBMessage$() {
    }
}

