/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.persistence.sql;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.elasticmq.persistence.CreateQueueMetadata;
import org.elasticmq.persistence.sql.DB;
import org.elasticmq.persistence.sql.DBQueue;
import org.elasticmq.persistence.sql.DBQueue$;
import org.elasticmq.util.Logging;
import scala.Function1;
import scala.StringContext;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalikejdbc.AutoSession;
import scalikejdbc.AutoSession$;
import scalikejdbc.ConnectionPoolContext;
import scalikejdbc.DB$;
import scalikejdbc.DBSession;
import scalikejdbc.GeneralizedTypeConstraintsForWithExtractor;
import scalikejdbc.SQLInterpolationString$;
import scalikejdbc.SQLToList;
import scalikejdbc.SettingsProvider;
import scalikejdbc.TxBoundary;
import scalikejdbc.WrappedResultSet;
import scalikejdbc.interpolation.SQLSyntax;
import scalikejdbc.package$;

@ScalaSignature(bytes="\u0006\u0005-4A\u0001D\u0007\u0001-!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0004-\u0001\t\u0007I1A\u0017\t\rQ\u0002\u0001\u0015!\u0003/\u0011\u001d)\u0004A1A\u0005\nYBa!\u0010\u0001!\u0002\u00139\u0004\"\u0002 \u0001\t\u0003y\u0004\"B\"\u0001\t\u0003!\u0005\"B+\u0001\t\u00031\u0006\"\u0002/\u0001\t\u0003i\u0006\"B0\u0001\t\u0003\u0001'aD)vKV,'+\u001a9pg&$xN]=\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0013'\u0005IQ\r\\1ti&\u001cW.\u001d\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tq\u0012%D\u0001 \u0015\t\u0001\u0013#\u0001\u0003vi&d\u0017B\u0001\u0012 \u0005\u001daunZ4j]\u001e\f!\u0001\u001a2\u0011\u0005\u00152S\"A\u0007\n\u0005\u001dj!A\u0001#C\u0003\u0019a\u0014N\\5u}Q\u0011!f\u000b\t\u0003K\u0001AQa\t\u0002A\u0002\u0011\nqa]3tg&|g.F\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014aC:dC2L7.\u001a6eE\u000eL!a\r\u0019\u0003\u0017\u0005+Ho\\*fgNLwN\\\u0001\tg\u0016\u001c8/[8oA\u0005IA/\u00192mK:\u000bW.Z\u000b\u0002oA\u0011\u0001hO\u0007\u0002s)\u0011!\bM\u0001\u000eS:$XM\u001d9pY\u0006$\u0018n\u001c8\n\u0005qJ$!C*R\u0019NKh\u000e^1y\u0003)!\u0018M\u00197f\u001d\u0006lW\rI\u0001\u0005IJ|\u0007\u000fF\u0001A!\tA\u0012)\u0003\u0002C3\t!QK\\5u\u0003\u001d1\u0017N\u001c3BY2$\u0012!\u0012\t\u0004\r:\u000bfBA$M\u001d\tA5*D\u0001J\u0015\tQU#\u0001\u0004=e>|GOP\u0005\u00025%\u0011Q*G\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005K\u0001\u0003MSN$(BA'\u001a!\t\u00116+D\u0001\u0010\u0013\t!vBA\nDe\u0016\fG/Z)vKV,W*\u001a;bI\u0006$\u0018-A\u0002bI\u0012$\"a\u0016.\u0011\u0005aA\u0016BA-\u001a\u0005\rIe\u000e\u001e\u0005\u00067&\u0001\r!U\u0001\fGJ,\u0017\r^3Rk\u0016,X-\u0001\u0004va\u0012\fG/\u001a\u000b\u0003/zCQa\u0017\u0006A\u0002E\u000baA]3n_Z,GCA,b\u0011\u0015\u00117\u00021\u0001d\u0003%\tX/Z;f\u001d\u0006lW\r\u0005\u0002eQ:\u0011QM\u001a\t\u0003\u0011fI!aZ\r\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003Of\u0001")
public class QueueRepository
implements Logging {
    private final AutoSession session;
    private final SQLSyntax tableName;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        QueueRepository queueRepository = this;
        synchronized (queueRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public AutoSession session() {
        return this.session;
    }

    private SQLSyntax tableName() {
        return this.tableName;
    }

    public void drop() {
        SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})).execute().apply((DBSession)this.session());
    }

    public List<CreateQueueMetadata> findAll() {
        Function1 & Serializable x$4 = (Function1 & Serializable)session -> {
            SQLToList sQLToList = SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})).map((Function1 & Serializable)rs -> DBQueue$.MODULE$.apply((WrappedResultSet)rs)).list();
            DBSession x$12 = session;
            GeneralizedTypeConstraintsForWithExtractor.$eq$colon$eq x$2 = GeneralizedTypeConstraintsForWithExtractor.$eq$colon$eq$.MODULE$.tpEquals();
            ConnectionPoolContext x$3 = sQLToList.apply$default$2();
            return ((List)sQLToList.apply(x$12, x$3, x$2)).map((Function1 & Serializable)x$1 -> x$1.toCreateQueue());
        };
        ConnectionPoolContext x$5 = DB$.MODULE$.localTx$default$2((Function1)x$4);
        TxBoundary x$6 = DB$.MODULE$.localTx$default$3((Function1)x$4);
        SettingsProvider x$7 = DB$.MODULE$.localTx$default$4((Function1)x$4);
        return (List)DB$.MODULE$.localTx((Function1)x$4, x$5, x$6, x$7);
    }

    public int add(CreateQueueMetadata createQueue) {
        DBQueue db = DBQueue$.MODULE$.from(createQueue);
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " (name, data)\n           values (", ",\n                   ", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName(), db.name(), db.data()})).update().apply((DBSession)this.session());
    }

    public int update(CreateQueueMetadata createQueue) {
        DBQueue db = DBQueue$.MODULE$.from(createQueue);
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set data = ", " where name = ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName(), db.data(), db.name()})).update().apply((DBSession)this.session());
    }

    public int remove(String queueName) {
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where name = ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName(), queueName})).update().apply((DBSession)this.session());
    }

    public QueueRepository(DB db) {
        Object object;
        LazyLogging.$init$((LazyLogging)this);
        this.session = AutoSession$.MODULE$;
        this.tableName = package$.MODULE$.SQLSyntax().createUnsafely("queue", package$.MODULE$.SQLSyntax().createUnsafely$default$2());
        if (db.persistenceConfig().pruneDataOnInit()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Deleting stored queues");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            object = BoxesRunTime.boxToBoolean((boolean)SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})).execute().apply((DBSession)this.session()));
        } else {
            object = BoxedUnit.UNIT;
        }
        SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    create table if not exists ", " (\n      name varchar unique,\n      data blob\n    )"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})).execute().apply((DBSession)this.session());
    }
}

