/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.persistence.sql;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.elasticmq.actor.queue.InternalMessage;
import org.elasticmq.persistence.sql.DB;
import org.elasticmq.persistence.sql.DBMessage;
import org.elasticmq.persistence.sql.DBMessage$;
import org.elasticmq.util.Logging;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scalikejdbc.AutoSession;
import scalikejdbc.AutoSession$;
import scalikejdbc.ConnectionPoolContext;
import scalikejdbc.DB$;
import scalikejdbc.DBSession;
import scalikejdbc.GeneralizedTypeConstraintsForWithExtractor;
import scalikejdbc.SQLInterpolationString$;
import scalikejdbc.SQLToList;
import scalikejdbc.SettingsProvider;
import scalikejdbc.TxBoundary;
import scalikejdbc.WrappedResultSet;
import scalikejdbc.interpolation.SQLSyntax;
import scalikejdbc.package$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\t\u0013\u0001mA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)\u0011\b\u0001C\u0001u!9a\b\u0001b\u0001\n\u0007y\u0004B\u0002$\u0001A\u0003%\u0001\tC\u0004H\u0001\t\u0007I\u0011\u0002%\t\r%\u0003\u0001\u0015!\u0003*\u0011\u001dQ\u0005A1A\u0005\n-Caa\u0015\u0001!\u0002\u0013a\u0005b\u0002+\u0001\u0005\u0004%I!\u0016\u0005\u00079\u0002\u0001\u000b\u0011\u0002,\t\u000bu\u0003A\u0011\u00010\t\u000b\t\u0004A\u0011A2\t\u000bU\u0004A\u0011\u0001<\t\u000bq\u0004A\u0011A?\t\r}\u0004A\u0011AA\u0001\u0005EiUm]:bO\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0003'Q\t1a]9m\u0015\t)b#A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'BA\f\u0019\u0003%)G.Y:uS\u000el\u0017OC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u00152\u0012\u0001B;uS2L!a\n\u0013\u0003\u000f1{wmZ5oO\u0006I\u0011/^3vK:\u000bW.\u001a\t\u0003UEr!aK\u0018\u0011\u00051rR\"A\u0017\u000b\u00059R\u0012A\u0002\u001fs_>$h(\u0003\u00021=\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u0001d$\u0001\u0002eEB\u0011agN\u0007\u0002%%\u0011\u0001H\u0005\u0002\u0003\t\n\u000ba\u0001P5oSRtDcA\u001e={A\u0011a\u0007\u0001\u0005\u0006Q\r\u0001\r!\u000b\u0005\u0006i\r\u0001\r!N\u0001\bg\u0016\u001c8/[8o+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u0017M\u001c\u0017\r\\5lK*$'mY\u0005\u0003\u000b\n\u00131\"Q;u_N+7o]5p]\u0006A1/Z:tS>t\u0007%A\u0004iCND\u0007*\u001a=\u0016\u0003%\n\u0001\u0002[1tQ\"+\u0007\u0010I\u0001\fKN\u001c\u0017\r]3e\u001d\u0006lW-F\u0001M!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003mC:<'\"A)\u0002\t)\fg/Y\u0005\u0003e9\u000bA\"Z:dCB,GMT1nK\u0002\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\"\u0002\u001b%tG/\u001a:q_2\fG/[8o\u0013\tY\u0006LA\u0005T#2\u001b\u0016P\u001c;bq\u0006QA/\u00192mK:\u000bW.\u001a\u0011\u0002\t\u0011\u0014x\u000e\u001d\u000b\u0002?B\u0011Q\u0004Y\u0005\u0003Cz\u0011A!\u00168ji\u00069a-\u001b8e\u00032dG#\u00013\u0011\u0007\u0015TWN\u0004\u0002gQ:\u0011AfZ\u0005\u0002?%\u0011\u0011NH\u0001\ba\u0006\u001c7.Y4f\u0013\tYGN\u0001\u0003MSN$(BA5\u001f!\tq7/D\u0001p\u0015\t\u0001\u0018/A\u0003rk\u0016,XM\u0003\u0002s-\u0005)\u0011m\u0019;pe&\u0011Ao\u001c\u0002\u0010\u0013:$XM\u001d8bY6+7o]1hK\u0006\u0019\u0011\r\u001a3\u0015\u0005]T\bCA\u000fy\u0013\tIhDA\u0002J]RDQa\u001f\bA\u00025\fq\"\u001b8uKJt\u0017\r\\'fgN\fw-Z\u0001\u0007kB$\u0017\r^3\u0015\u0005]t\b\"B>\u0010\u0001\u0004i\u0017A\u0002:f[>4X\rF\u0002x\u0003\u0007Aa!!\u0002\u0011\u0001\u0004I\u0013!C7fgN\fw-Z%e\u0001")
public class MessageRepository
implements Logging {
    private final AutoSession session;
    private final String hashHex;
    private final String escapedName;
    private final SQLSyntax tableName;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        MessageRepository messageRepository = this;
        synchronized (messageRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public AutoSession session() {
        return this.session;
    }

    private String hashHex() {
        return this.hashHex;
    }

    private String escapedName() {
        return this.escapedName;
    }

    private SQLSyntax tableName() {
        return this.tableName;
    }

    public void drop() {
        boolean bl = SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})).execute().apply((DBSession)this.session());
        if (!true) {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public List<InternalMessage> findAll() {
        Function1 & Serializable x$4 = (Function1 & Serializable)session -> {
            SQLToList sQLToList = SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})).map((Function1 & Serializable)rs -> DBMessage$.MODULE$.apply((WrappedResultSet)rs)).list();
            DBSession x$1 = session;
            GeneralizedTypeConstraintsForWithExtractor.$eq$colon$eq x$2 = GeneralizedTypeConstraintsForWithExtractor.$eq$colon$eq$.MODULE$.tpEquals();
            ConnectionPoolContext x$32 = sQLToList.apply$default$2();
            return ((List)sQLToList.apply(x$1, x$32, x$2)).map((Function1 & Serializable)x$3 -> x$3.toInternalMessage());
        };
        ConnectionPoolContext x$5 = DB$.MODULE$.localTx$default$2((Function1)x$4);
        TxBoundary x$6 = DB$.MODULE$.localTx$default$3((Function1)x$4);
        SettingsProvider x$7 = DB$.MODULE$.localTx$default$4((Function1)x$4);
        return (List)DB$.MODULE$.localTx((Function1)x$4, x$5, x$6, x$7);
    }

    public int add(InternalMessage internalMessage) {
        DBMessage message = DBMessage$.MODULE$.from(internalMessage);
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", "\n           (message_id, delivery_receipts, next_delivery, content, attributes, created, received, receive_count, group_id, deduplication_id, tracing_id, sequence_number, dead_letter_source_queue_name)\n           values (", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName(), message.messageId(), message.deliveryReceipts(), BoxesRunTime.boxToLong((long)message.nextDelivery()), message.content(), message.attributes(), BoxesRunTime.boxToLong((long)message.created()), message.received(), BoxesRunTime.boxToInteger((int)message.receiveCount()), message.groupId(), message.deduplicationId(), message.tracingId(), message.sequenceNumber(), message.deadLetterSourceQueueName()})).update().apply((DBSession)this.session());
    }

    public int update(InternalMessage internalMessage) {
        DBMessage message = DBMessage$.MODULE$.from(internalMessage);
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set\n                    delivery_receipts = ", ",\n                    next_delivery = ", ",\n                    attributes = ", ",\n                    received = ", ",\n                    receive_count = ", ",\n                    tracing_id = ", ",\n                    sequence_number = ", ",\n                    dead_letter_source_queue_name = ", "\n              where message_id = ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName(), message.deliveryReceipts(), BoxesRunTime.boxToLong((long)message.nextDelivery()), message.attributes(), message.received(), BoxesRunTime.boxToInteger((int)message.receiveCount()), message.tracingId(), message.sequenceNumber(), message.deadLetterSourceQueueName(), message.messageId()})).update().apply((DBSession)this.session());
    }

    public int remove(String messageId) {
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where message_id = ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName(), messageId})).update().apply((DBSession)this.session());
    }

    public MessageRepository(String queueName, DB db) {
        LazyLogging.$init$((LazyLogging)this);
        this.session = AutoSession$.MODULE$;
        this.hashHex = RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(queueName.hashCode()));
        this.escapedName = queueName.replace(".", "_").replace("-", "_");
        this.tableName = package$.MODULE$.SQLSyntax().createUnsafely(new StringBuilder(9).append("message_").append(this.escapedName()).append("_").append(this.hashHex()).toString(), package$.MODULE$.SQLSyntax().createUnsafely$default$2());
        if (db.persistenceConfig().pruneDataOnInit()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Deleting stored messages for queue {}", (Object)queueName);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boolean bl = SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})).execute().apply((DBSession)this.session());
            if (!true) {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
        SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    create table if not exists ", " (\n      message_id varchar unique,\n      delivery_receipts blob,\n      next_delivery bigint,\n      content blob,\n      attributes blob,\n      created bigint,\n      received bigint,\n      receive_count int,\n      group_id varchar,\n      deduplication_id varchar,\n      tracing_id varchar,\n      sequence_number varchar,\n      dead_letter_source_queue_name varchar\n    )"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})).execute().apply((DBSession)this.session());
    }
}

