/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.persistence.sql;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.elasticmq.actor.queue.InternalMessage;
import org.elasticmq.persistence.sql.DB;
import org.elasticmq.persistence.sql.DBMessage;
import org.elasticmq.persistence.sql.DBMessage$;
import org.elasticmq.util.Logging;
import scala.Function1;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scalikejdbc.AutoSession;
import scalikejdbc.AutoSession$;
import scalikejdbc.ConnectionPoolContext;
import scalikejdbc.DB$;
import scalikejdbc.DBSession;
import scalikejdbc.GeneralizedTypeConstraintsForWithExtractor;
import scalikejdbc.SQLInterpolationString$;
import scalikejdbc.SQLToList;
import scalikejdbc.WrappedResultSet;
import scalikejdbc.interpolation.SQLSyntax;
import scalikejdbc.package$;

public class MessageRepository
implements LazyLogging,
Logging {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MessageRepository.class.getDeclaredField("logger$lzy1"));
    private volatile transient Object logger$lzy1;
    private final AutoSession session = AutoSession$.MODULE$;
    private final SQLSyntax tableName;

    public MessageRepository(String queueName, DB db) {
        String hashHex = RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(queueName.hashCode()));
        String escapedName = queueName.replace(".", "_").replace("-", "_");
        this.tableName = package$.MODULE$.SQLSyntax().createUnsafely(new StringBuilder(9).append("message_").append(escapedName).append("_").append(hashHex).toString(), package$.MODULE$.SQLSyntax().createUnsafely$default$2());
        if (db.persistenceConfig().pruneDataOnInit()) {
            Logger LoggerImpl_this = this.logger();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Deleting stored messages for queue {}", (Object)queueName);
            }
            boolean _$2 = SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName})).execute().apply((DBSession)this.session());
        }
        SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n    create table if not exists ", " (\n      message_id varchar unique,\n      delivery_receipts blob,\n      next_delivery bigint,\n      content blob,\n      attributes blob,\n      created bigint,\n      received bigint,\n      receive_count int,\n      group_id varchar,\n      deduplication_id varchar,\n      tracing_id varchar,\n      sequence_number varchar,\n      dead_letter_source_queue_name varchar\n    )"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName})).execute().apply((DBSession)this.session());
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogging.logger$((LazyLogging)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AutoSession session() {
        return this.session;
    }

    public void drop() {
        boolean _$3 = SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName})).execute().apply((DBSession)this.session());
    }

    public List<InternalMessage> findAll() {
        Function1 & Serializable intersect = (Function1 & Serializable)session -> {
            SQLToList sQLToList = SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select * from ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName})).map((Function1 & Serializable)rs -> DBMessage$.MODULE$.apply((WrappedResultSet)rs)).list();
            GeneralizedTypeConstraintsForWithExtractor.$eq$colon$eq $eq$colon$eq2 = GeneralizedTypeConstraintsForWithExtractor.$eq$colon$eq$.MODULE$.tpEquals();
            ConnectionPoolContext connectionPoolContext = sQLToList.apply$default$2();
            return ((List)sQLToList.apply(session, connectionPoolContext, $eq$colon$eq2)).map((Function1 & Serializable)_$1 -> _$1.toInternalMessage());
        };
        return (List)DB$.MODULE$.localTx((Function1)intersect, DB$.MODULE$.localTx$default$2((Function1)intersect), DB$.MODULE$.localTx$default$3((Function1)intersect), DB$.MODULE$.localTx$default$4((Function1)intersect));
    }

    public int add(InternalMessage internalMessage) {
        DBMessage message = DBMessage$.MODULE$.from(internalMessage);
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", "\n           (message_id, delivery_receipts, next_delivery, content, attributes, created, received, receive_count, group_id, deduplication_id, tracing_id, sequence_number, dead_letter_source_queue_name)\n           values (", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ",\n                   ", ")"}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName, message.messageId(), message.deliveryReceipts(), BoxesRunTime.boxToLong((long)message.nextDelivery()), message.content(), message.attributes(), BoxesRunTime.boxToLong((long)message.created()), message.received(), BoxesRunTime.boxToInteger((int)message.receiveCount()), message.groupId(), message.deduplicationId(), message.tracingId(), message.sequenceNumber(), message.deadLetterSourceQueueName()})).update().apply((DBSession)this.session());
    }

    public int update(InternalMessage internalMessage) {
        DBMessage message = DBMessage$.MODULE$.from(internalMessage);
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"update ", " set\n                    delivery_receipts = ", ",\n                    next_delivery = ", ",\n                    attributes = ", ",\n                    received = ", ",\n                    receive_count = ", ",\n                    tracing_id = ", ",\n                    sequence_number = ", ",\n                    dead_letter_source_queue_name = ", "\n              where message_id = ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName, message.deliveryReceipts(), BoxesRunTime.boxToLong((long)message.nextDelivery()), message.attributes(), message.received(), BoxesRunTime.boxToInteger((int)message.receiveCount()), message.tracingId(), message.sequenceNumber(), message.deadLetterSourceQueueName(), message.messageId()})).update().apply((DBSession)this.session());
    }

    public int remove(String messageId) {
        return SQLInterpolationString$.MODULE$.sql$extension(package$.MODULE$.scalikejdbcSQLInterpolationImplicitDef(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"delete from ", " where message_id = ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName, messageId})).update().apply((DBSession)this.session());
    }
}

