package org.elasticmq.rest.sqs

import akka.actor.{Props, Actor, ActorSystem}
import akka.io.{Inet, IO}
import spray.can.Http
import akka.pattern.ask
import scala.concurrent.Await
import scala.concurrent.duration._
import akka.util.Timeout

object SprayTesting extends App {
  while(true) {
    implicit val as = ActorSystem()
    implicit val timeout = Timeout(60000L)

    val listener = as.actorOf(Props(new Actor {
      def receive = {
        case x => println("Received: " + x)
      }
    }))

    val bindFuture = IO(Http) ? Http.Bind(listener, "localhost", 9321, 100, List(Inet.SO.ReuseAddress(on = true)), None)
    println(Await.result(bindFuture, 10.seconds))

    val bindFuture2 = IO(Http) ? Http.Bind(listener, "localhost", 9322, 100, List(Inet.SO.ReuseAddress(on = true)), None)
    println(Await.result(bindFuture2, 10.seconds))

    val closeAllFuture = IO(Http) ? Http.CloseAll
    println(Await.result(closeAllFuture, 10.seconds))

    val closeAllFuture2 = IO(Http) ? Http.CloseAll
    println(Await.result(closeAllFuture2, 10.seconds))

    as.shutdown()
    as.awaitTermination()
  }
}
