/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.rest.sqs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import cps.monads.FutureAsyncMonad$package$;
import cps.monads.FutureAsyncMonadAPI;
import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.util.Timeout;
import org.elasticmq.DeadLettersQueueData$;
import org.elasticmq.MillisVisibilityTimeout$;
import org.elasticmq.QueueData;
import org.elasticmq.QueueStatistics;
import org.elasticmq.actor.reply.Replyable;
import org.elasticmq.msg.GetQueueStatistics$;
import org.elasticmq.msg.LookupQueue$;
import org.elasticmq.msg.UpdateQueueDeadLettersQueue$;
import org.elasticmq.msg.UpdateQueueDefaultVisibilityTimeout$;
import org.elasticmq.msg.UpdateQueueDelay$;
import org.elasticmq.msg.UpdateQueueReceiveMessageWait$;
import org.elasticmq.rest.sqs.AttributesModule;
import org.elasticmq.rest.sqs.AwsConfiguration;
import org.elasticmq.rest.sqs.Constants$;
import org.elasticmq.rest.sqs.FifoAttributeNames$;
import org.elasticmq.rest.sqs.QueueReadableAttributeNames$;
import org.elasticmq.rest.sqs.SQSException;
import org.elasticmq.rest.sqs.SQSException$;
import org.elasticmq.rest.sqs.UnsupportedAttributeNames$;
import org.elasticmq.rest.sqs.model.GenericRedrivePolicy;
import org.elasticmq.rest.sqs.model.RedrivePolicy$;
import org.elasticmq.rest.sqs.model.RedrivePolicyJson$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import spray.json.DeserializationException;
import spray.json.JsonParser;

public interface QueueAttributesOps
extends AttributesModule,
AwsConfiguration {
    public static void $init$(QueueAttributesOps $this) {
        $this.org$elasticmq$rest$sqs$QueueAttributesOps$_setter_$attributeValuesCalculator_$eq($this.new AttributesModule.AttributeValuesCalculator());
    }

    public AttributesModule.AttributeValuesCalculator attributeValuesCalculator();

    public void org$elasticmq$rest$sqs$QueueAttributesOps$_setter_$attributeValuesCalculator_$eq(AttributesModule.AttributeValuesCalculator var1);

    public static Future getAllQueueAttributes$(QueueAttributesOps $this, ActorRef queueActor, QueueData queueData, Timeout timeout, ExecutionContext executionContext) {
        return $this.getAllQueueAttributes(queueActor, queueData, timeout, executionContext);
    }

    default public Future<List<Tuple2<String, String>>> getAllQueueAttributes(ActorRef queueActor, QueueData queueData, Timeout timeout, ExecutionContext executionContext) {
        return this.getQueueAttributes(QueueReadableAttributeNames$.MODULE$.AllAttributeNames(), queueActor, queueData, timeout, executionContext);
    }

    public static Future getQueueAttributes$(QueueAttributesOps $this, List attributeNames, ActorRef queueActor, QueueData queueData, Timeout timeout, ExecutionContext executionContext) {
        return $this.getQueueAttributes((List<String>)attributeNames, queueActor, queueData, timeout, executionContext);
    }

    default public Future<List<Tuple2<String, String>>> getQueueAttributes(List<String> attributeNames, ActorRef queueActor, QueueData queueData, Timeout timeout, ExecutionContext executionContext) {
        return Future$.MODULE$.sequence((IterableOnce)this.calculateAttributeValues$1(queueActor, queueData, timeout, executionContext, attributeNames).map((Function1 & Serializable)p -> ((Future)p._2()).map((Function1 & Serializable)_$4 -> Tuple2$.MODULE$.apply(p._1(), _$4), executionContext)), BuildFrom$.MODULE$.buildFromIterableOps(), executionContext);
    }

    public static Iterable setQueueAttributes$(QueueAttributesOps $this, Map attributes, ActorRef queueActor, ActorRef queueManagerActor, Timeout timeout, ExecutionContext executionContext) {
        return $this.setQueueAttributes((Map<String, String>)attributes, queueActor, queueManagerActor, timeout, executionContext);
    }

    default public Iterable<Future<Object>> setQueueAttributes(Map<String, String> attributes, ActorRef queueActor, ActorRef queueManagerActor, Timeout timeout, ExecutionContext executionContext) {
        return (Iterable)attributes.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String attributeName = (String)tuple2._1();
                String attributeValue = (String)tuple2._2();
                String string = attributeName;
                String string2 = Constants$.MODULE$.VisibilityTimeoutParameter();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueActor).$qmark((Replyable)UpdateQueueDefaultVisibilityTimeout$.MODULE$.apply(MillisVisibilityTimeout$.MODULE$.fromSeconds(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(attributeValue)))), timeout, (ClassTag)ClassTag$.MODULE$.Unit());
                }
                String string4 = Constants$.MODULE$.DelaySecondsAttribute();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueActor).$qmark((Replyable)UpdateQueueDelay$.MODULE$.apply(Duration.ofSeconds(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(attributeValue)))), timeout, (ClassTag)ClassTag$.MODULE$.Unit());
                }
                String string6 = Constants$.MODULE$.ReceiveMessageWaitTimeSecondsAttribute();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    return org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueActor).$qmark((Replyable)UpdateQueueReceiveMessageWait$.MODULE$.apply(Duration.ofSeconds(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(attributeValue)))), timeout, (ClassTag)ClassTag$.MODULE$.Unit());
                }
                String string8 = Constants$.MODULE$.RedrivePolicyParameter();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    GenericRedrivePolicy genericRedrivePolicy;
                    try {
                        genericRedrivePolicy = (GenericRedrivePolicy)spray.json.package$.MODULE$.enrichString(attributeValue).parseJson().convertTo(RedrivePolicyJson$.MODULE$.backwardCompatibleFormat());
                    }
                    catch (DeserializationException e) {
                        Logger LoggerImpl_this = ((LazyLogging)this).logger();
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            LoggerImpl_this.underlying().warn("Cannot deserialize the redrive policy attribute", (Throwable)e);
                        }
                        throw new SQSException("MalformedQueryString", SQSException$.MODULE$.$lessinit$greater$default$2(), SQSException$.MODULE$.$lessinit$greater$default$3(), SQSException$.MODULE$.$lessinit$greater$default$4());
                    }
                    catch (JsonParser.ParsingException e) {
                        Logger LoggerImpl_this = ((LazyLogging)this).logger();
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            LoggerImpl_this.underlying().warn("Cannot parse the redrive policy attribute", (Throwable)e);
                        }
                        throw new SQSException("MalformedQueryString", SQSException$.MODULE$.$lessinit$greater$default$2(), SQSException$.MODULE$.$lessinit$greater$default$3(), SQSException$.MODULE$.$lessinit$greater$default$4());
                    }
                    GenericRedrivePolicy redrivePolicy = genericRedrivePolicy;
                    return (Future)FutureAsyncMonad$package$.MODULE$.FutureAsyncMonad(executionContext).apply((Function1 & Serializable)ctx -> {
                        FutureAsyncMonadAPI cpsMonad = ctx.monad();
                        return cpsMonad.spawn(() -> QueueAttributesOps.setQueueAttributes$$anonfun$1$$anonfun$1$$anonfun$1(queueActor, queueManagerActor, timeout, executionContext, redrivePolicy, cpsMonad));
                    });
                }
                String attr = string;
                if (UnsupportedAttributeNames$.MODULE$.AllUnsupportedAttributeNames().contains((Object)attr)) {
                    Logger LoggerImpl_this = ((LazyLogging)this).logger();
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn(new StringBuilder(57).append("Ignored attribute \"").append(attr).append("\" (supported by SQS but not ElasticMQ)").toString());
                    }
                    return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                }
                String attr2 = string;
                Logger LoggerImpl_this = ((LazyLogging)this).logger();
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn(new StringBuilder(47).append("Unsupported attribute \"").append(attr2).append("\" (failing on ElasticMQ)").toString());
                }
                return Future$.MODULE$.failed((Throwable)new SQSException("InvalidAttributeName", SQSException$.MODULE$.$lessinit$greater$default$2(), SQSException$.MODULE$.$lessinit$greater$default$3(), SQSException$.MODULE$.$lessinit$greater$default$4()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static Future stats$lzyINIT1$1(ActorRef queueActor$1, Timeout timeout$1, LazyRef stats$lzy1$1) {
        Future future;
        LazyRef lazyRef = stats$lzy1$1;
        synchronized (lazyRef) {
            future = (Future)(stats$lzy1$1.initialized() ? stats$lzy1$1.value() : stats$lzy1$1.initialize((Object)org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueActor$1).$qmark((Replyable)GetQueueStatistics$.MODULE$.apply(System.currentTimeMillis()), timeout$1, ClassTag$.MODULE$.apply(QueueStatistics.class))));
        }
        return future;
    }

    private static Future stats$1(ActorRef queueActor$3, Timeout timeout$3, LazyRef stats$lzy1$2) {
        return (Future)(stats$lzy1$2.initialized() ? stats$lzy1$2.value() : QueueAttributesOps.stats$lzyINIT1$1(queueActor$3, timeout$3, stats$lzy1$2));
    }

    private List calculateAttributeValues$1(ActorRef queueActor$2, QueueData queueData$1, Timeout timeout$2, ExecutionContext executionContext$1, List attributeNames) {
        LazyRef lazyRef = new LazyRef();
        Seq alwaysAvailableParameterRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributesModule.AttributeValuesCalculator.Rule[]{this.AttributeValuesCalculator().Rule().apply(Constants$.MODULE$.VisibilityTimeoutParameter(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)queueData$1.defaultVisibilityTimeout().seconds()).toString())), this.AttributeValuesCalculator().Rule().apply(Constants$.MODULE$.DelaySecondsAttribute(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)queueData$1.delay().getSeconds()).toString())), this.AttributeValuesCalculator().Rule().apply(QueueReadableAttributeNames$.MODULE$.ApproximateNumberOfMessagesAttribute(), (Function0 & Serializable)() -> QueueAttributesOps.stats$1(queueActor$2, timeout$2, lazyRef).map((Function1 & Serializable)_$1 -> BoxesRunTime.boxToLong((long)_$1.approximateNumberOfVisibleMessages()).toString(), executionContext$1)), this.AttributeValuesCalculator().Rule().apply(QueueReadableAttributeNames$.MODULE$.ApproximateNumberOfMessagesNotVisibleAttribute(), (Function0 & Serializable)() -> QueueAttributesOps.stats$1(queueActor$2, timeout$2, lazyRef).map((Function1 & Serializable)_$2 -> BoxesRunTime.boxToLong((long)_$2.approximateNumberOfInvisibleMessages()).toString(), executionContext$1)), this.AttributeValuesCalculator().Rule().apply(QueueReadableAttributeNames$.MODULE$.ApproximateNumberOfMessagesDelayedAttribute(), (Function0 & Serializable)() -> QueueAttributesOps.stats$1(queueActor$2, timeout$2, lazyRef).map((Function1 & Serializable)_$3 -> BoxesRunTime.boxToLong((long)_$3.approximateNumberOfMessagesDelayed()).toString(), executionContext$1)), this.AttributeValuesCalculator().Rule().apply(QueueReadableAttributeNames$.MODULE$.CreatedTimestampAttribute(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)(queueData$1.created().toInstant().toEpochMilli() / 1000L)).toString())), this.AttributeValuesCalculator().Rule().apply(QueueReadableAttributeNames$.MODULE$.LastModifiedTimestampAttribute(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)(queueData$1.lastModified().toInstant().toEpochMilli() / 1000L)).toString())), this.AttributeValuesCalculator().Rule().apply(Constants$.MODULE$.ReceiveMessageWaitTimeSecondsAttribute(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToLong((long)queueData$1.receiveMessageWait().getSeconds()).toString())), this.AttributeValuesCalculator().Rule().apply(Constants$.MODULE$.QueueArnAttribute(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)this.getArn(queueData$1.name())))}));
        Seq optionalRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{queueData$1.deadLettersQueue().map((Function1 & Serializable)dlq -> RedrivePolicy$.MODULE$.apply(dlq.name(), this.awsRegion(), this.awsAccountId(), dlq.maxReceiveCount())).map((Function1 & Serializable)redrivePolicy -> this.AttributeValuesCalculator().Rule().apply(Constants$.MODULE$.RedrivePolicyParameter(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)spray.json.package$.MODULE$.enrichAny(redrivePolicy).toJson(RedrivePolicyJson$.MODULE$.format()).toString())))}));
        Seq fifoRules = queueData$1.isFifo() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributesModule.AttributeValuesCalculator.Rule[]{this.AttributeValuesCalculator().Rule().apply(FifoAttributeNames$.MODULE$.FifoQueue(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)queueData$1.isFifo()).toString())), this.AttributeValuesCalculator().Rule().apply(FifoAttributeNames$.MODULE$.ContentBasedDeduplication(), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)queueData$1.hasContentBasedDeduplication()).toString()))})) : (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        Seq rules = (Seq)((IterableOps)alwaysAvailableParameterRules.$plus$plus((IterableOnce)optionalRules.flatten(Predef$.MODULE$.$conforms()))).$plus$plus((IterableOnce)fifoRules);
        return this.attributeValuesCalculator().calculate((List<String>)attributeNames, rules);
    }

    private static Future setQueueAttributes$$anonfun$1$$anonfun$1$$anonfun$1(ActorRef queueActor$8, ActorRef queueManagerActor$2, Timeout timeout$8, ExecutionContext executionContext$7, GenericRedrivePolicy redrivePolicy$2, FutureAsyncMonadAPI cpsMonad$1) {
        Future x$proxy1 = org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueManagerActor$2).$qmark((Replyable)LookupQueue$.MODULE$.apply(redrivePolicy$2.queueName()), timeout$8, ClassTag$.MODULE$.apply(Option.class));
        FutureAsyncMonadAPI fm = FutureAsyncMonad$package$.MODULE$.FutureAsyncMonad(executionContext$7);
        return cpsMonad$1.flatMap(cpsMonad$1.map(x$proxy1, (Function1 & Serializable)x -> x), (Function1 & Serializable)v -> {
            Option deadLettersQueueActor = v;
            return cpsMonad$1.flatMap(deadLettersQueueActor.isEmpty() ? cpsMonad$1.error((Throwable)SQSException$.MODULE$.nonExistentQueue()) : cpsMonad$1.pure((Object)BoxedUnit.UNIT), (Function1 & Serializable)_$112 -> cpsMonad$1.flatMap(redrivePolicy$2.maxReceiveCount() < 1 || redrivePolicy$2.maxReceiveCount() > 1000 ? cpsMonad$1.error((Throwable)SQSException$.MODULE$.invalidParameterValue()) : cpsMonad$1.pure((Object)BoxedUnit.UNIT), (Function1 & Serializable)_$11 -> cpsMonad$1.pure((Object)org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueActor$8).$qmark((Replyable)UpdateQueueDeadLettersQueue$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)DeadLettersQueueData$.MODULE$.apply(redrivePolicy$2.queueName(), redrivePolicy$2.maxReceiveCount())), deadLettersQueueActor), timeout$8, (ClassTag)ClassTag$.MODULE$.Unit()))));
        });
    }
}

