/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.rest.sqs.directives;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.server.Directive;
import org.apache.pekko.http.scaladsl.server.Directive$;
import org.apache.pekko.http.scaladsl.server.Directives;
import org.apache.pekko.http.scaladsl.server.MalformedQueryParamRejection$;
import org.apache.pekko.http.scaladsl.server.PathMatcher;
import org.apache.pekko.http.scaladsl.server.Rejection;
import org.apache.pekko.http.scaladsl.server.RequestContext;
import org.apache.pekko.http.scaladsl.server.RouteResult;
import org.apache.pekko.http.scaladsl.server.StandardRoute$;
import org.apache.pekko.http.scaladsl.server.util.ApplyConverter$;
import org.apache.pekko.http.scaladsl.server.util.Tuple$;
import org.apache.pekko.http.scaladsl.server.util.TupleOps;
import org.elasticmq.QueueData;
import org.elasticmq.actor.reply.Replyable;
import org.elasticmq.actor.reply.package$;
import org.elasticmq.msg.GetQueueData$;
import org.elasticmq.msg.LookupQueue$;
import org.elasticmq.rest.sqs.ActorSystemModule;
import org.elasticmq.rest.sqs.Constants$;
import org.elasticmq.rest.sqs.ContextPathModule;
import org.elasticmq.rest.sqs.QueueManagerActorModule;
import org.elasticmq.rest.sqs.SQSException$;
import org.elasticmq.rest.sqs.directives.FutureDirectives;
import org.elasticmq.rest.sqs.directives.QueueDirectives$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public interface QueueDirectives {
    public static Regex AccountIdRegex() {
        return QueueDirectives$.MODULE$.AccountIdRegex();
    }

    public static Function1 queueActorFromUrl$(QueueDirectives $this, String queueUrl, Function1 body) {
        return $this.queueActorFromUrl(queueUrl, (Function1<ActorRef, Function1<RequestContext, Future<RouteResult>>>)body);
    }

    default public Function1<RequestContext, Future<RouteResult>> queueActorFromUrl(String queueUrl, Function1<ActorRef, Function1<RequestContext, Future<RouteResult>>> body) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(this.getQueueNameFromQueueUrl(queueUrl), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)queueName -> this.queueActor((String)queueName, body));
    }

    public static Function1 queueActorAndNameFromUrl$(QueueDirectives $this, String queueUrl, Function2 body) {
        return $this.queueActorAndNameFromUrl(queueUrl, (Function2<ActorRef, String, Function1<RequestContext, Future<RouteResult>>>)body);
    }

    default public Function1<RequestContext, Future<RouteResult>> queueActorAndNameFromUrl(String queueUrl, Function2<ActorRef, String, Function1<RequestContext, Future<RouteResult>>> body) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(this.getQueueNameFromQueueUrl(queueUrl), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)queueName -> this.queueActor((String)queueName, (Function1<ActorRef, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)qa -> (Function1)body.apply(qa, queueName)));
    }

    public static Function1 queueActorAndDataFromQueueName$(QueueDirectives $this, String queueName, Function2 body) {
        return $this.queueActorAndDataFromQueueName(queueName, (Function2<ActorRef, QueueData, Function1<RequestContext, Future<RouteResult>>>)body);
    }

    default public Function1<RequestContext, Future<RouteResult>> queueActorAndDataFromQueueName(String queueName, Function2<ActorRef, QueueData, Function1<RequestContext, Future<RouteResult>>> body) {
        return this.queueActor(queueName, (Function1<ActorRef, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)qa -> this.queueData((ActorRef)qa, (Function1<QueueData, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)qd -> (Function1)body.apply(qa, qd)));
    }

    public static Function1 queueActorAndDataFromQueueUrl$(QueueDirectives $this, String queueUrl, Function2 body) {
        return $this.queueActorAndDataFromQueueUrl(queueUrl, (Function2<ActorRef, QueueData, Function1<RequestContext, Future<RouteResult>>>)body);
    }

    default public Function1<RequestContext, Future<RouteResult>> queueActorAndDataFromQueueUrl(String queueUrl, Function2<ActorRef, QueueData, Function1<RequestContext, Future<RouteResult>>> body) {
        return (Function1)Directive$.MODULE$.addDirectiveApply(this.getQueueNameFromQueueUrl(queueUrl), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable)queueName -> this.queueActor((String)queueName, (Function1<ActorRef, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)qa -> this.queueData((ActorRef)qa, (Function1<QueueData, Function1<RequestContext, Future<RouteResult>>>)(Function1 & Serializable)qd -> (Function1)body.apply(qa, qd))));
    }

    public static Directive getQueueNameFromQueueUrl$(QueueDirectives $this, String queueUrl) {
        return $this.getQueueNameFromQueueUrl(queueUrl);
    }

    default public Directive<Tuple1<String>> getQueueNameFromQueueUrl(String queueUrl) {
        PathMatcher pathMatcher;
        PathMatcher defaultMatcher;
        PathMatcher pathMatcher2;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((ContextPathModule)((Directives)this)).contextPath()))) {
            PathMatcher pathWithContext = ((Directives)this).separateOnSlashes(((ContextPathModule)((Directives)this)).contextPath()).$div(((Directives)this)._regex2PathMatcher(QueueDirectives$.MODULE$.AccountIdRegex()), TupleOps.Join$.MODULE$.join0P()).$div(((Directives)this)._regex2PathMatcher(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^/]+"))), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1()))));
            pathMatcher2 = ((Directives)this).Slash().$tilde(pathWithContext, TupleOps.Join$.MODULE$.join0P()).$bar(pathWithContext, Tuple$.MODULE$.forTuple2());
        } else {
            pathMatcher2 = defaultMatcher = ((Directives)this).Slash().$tilde(((Directives)this)._regex2PathMatcher(QueueDirectives$.MODULE$.AccountIdRegex()), TupleOps.Join$.MODULE$.join0P()).$div(((Directives)this)._regex2PathMatcher(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^/]+"))), TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1()))));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(((ContextPathModule)((Directives)this)).contextPath()))) {
            PathMatcher pathWithContext = ((Directives)this).separateOnSlashes(((ContextPathModule)((Directives)this)).contextPath()).$div(((Directives)this)._regex2PathMatcher(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^/]+"))), TupleOps.Join$.MODULE$.join0P());
            pathMatcher = ((Directives)this).Slash().$tilde(pathWithContext, TupleOps.Join$.MODULE$.join0P()).$bar(pathWithContext, Tuple$.MODULE$.forTuple1());
        } else {
            pathMatcher = ((Directives)this).Slash().$tilde(((Directives)this)._regex2PathMatcher(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^/]+"))), TupleOps.Join$.MODULE$.join0P());
        }
        PathMatcher noAccountIdMatcher = pathMatcher;
        PathMatcher.Matching matching = (PathMatcher.Matching)defaultMatcher.apply((Object)Uri$.MODULE$.apply(queueUrl).path());
        if (matching instanceof PathMatcher.Matched) {
            PathMatcher.Matched matched = PathMatcher.Matched$.MODULE$.unapply((PathMatcher.Matched)matching);
            Uri.Path path = matched._1();
            Tuple2 tuple2 = (Tuple2)matched._2();
            if (tuple2 != null) {
                String queueName = (String)tuple2._2();
                return ((Directives)this).provide((Object)queueName);
            }
        }
        if (PathMatcher.Unmatched$.MODULE$.equals(matching)) {
            PathMatcher.Matching matching2 = (PathMatcher.Matching)noAccountIdMatcher.apply((Object)Uri$.MODULE$.apply(queueUrl).path());
            if (matching2 instanceof PathMatcher.Matched) {
                PathMatcher.Matched matched = PathMatcher.Matched$.MODULE$.unapply((PathMatcher.Matched)matching2);
                Uri.Path path = matched._1();
                Tuple1 tuple1 = (Tuple1)matched._2();
                if (tuple1 != null) {
                    String queueName = (String)tuple1._1();
                    return ((Directives)this).provide((Object)queueName);
                }
            }
            if (PathMatcher.Unmatched$.MODULE$.equals(matching2)) {
                return StandardRoute$.MODULE$.toDirective(((Directives)this).reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{MalformedQueryParamRejection$.MODULE$.apply(Constants$.MODULE$.QueueUrlParameter(), "Invalid queue url, the path should be /<accountId>/<queueName> or /<queueName>", MalformedQueryParamRejection$.MODULE$.$lessinit$greater$default$3())})), Tuple$.MODULE$.forTuple1());
            }
            throw new MatchError((Object)matching2);
        }
        throw new MatchError((Object)matching);
    }

    private Function1<RequestContext, Future<RouteResult>> queueActor(String queueName, Function1<ActorRef, Function1<RequestContext, Future<RouteResult>>> body) {
        return ((FutureDirectives)((Directives)this)).futureRouteToRoute((Future<Function1<RequestContext, Future<RouteResult>>>)package$.MODULE$.ReplyActorRef(((QueueManagerActorModule)((Directives)this)).queueManagerActor()).$qmark((Replyable)LookupQueue$.MODULE$.apply(queueName), ((ActorSystemModule)((Directives)this)).timeout(), ClassTag$.MODULE$.apply(Option.class)).map((Function1 & Serializable)lookupResult -> {
            Option option = lookupResult;
            if (option instanceof Some) {
                ActorRef a = (ActorRef)((Some)option).value();
                return (Function1)body.apply((Object)a);
            }
            if (None$.MODULE$.equals(option)) {
                throw SQSException$.MODULE$.nonExistentQueue();
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)((ActorSystemModule)((Directives)this)).messageDispatcher()));
    }

    private Function1<RequestContext, Future<RouteResult>> queueData(ActorRef queueActor, Function1<QueueData, Function1<RequestContext, Future<RouteResult>>> body) {
        return ((FutureDirectives)((Directives)this)).futureRouteToRoute((Future<Function1<RequestContext, Future<RouteResult>>>)package$.MODULE$.ReplyActorRef(queueActor).$qmark((Replyable)GetQueueData$.MODULE$.apply(), ((ActorSystemModule)((Directives)this)).timeout(), ClassTag$.MODULE$.apply(QueueData.class)).map((Function1 & Serializable)queueData -> (Function1)body.apply(queueData), (ExecutionContext)((ActorSystemModule)((Directives)this)).messageDispatcher()));
    }
}

