/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.elasticmq.ElasticMQError;
import org.elasticmq.actor.QueueManagerActor;
import org.elasticmq.actor.queue.QueueEvent;
import org.elasticmq.actor.reply.Replyable;
import org.elasticmq.msg.CreateQueue$;
import org.elasticmq.persistence.file.ConfigBasedQueuePersistenceActor;
import org.elasticmq.persistence.sql.SqlQueuePersistenceActor;
import org.elasticmq.rest.sqs.SQSRestServer;
import org.elasticmq.rest.sqs.TheSQSRestServerBuilder$;
import org.elasticmq.rest.stats.StatisticsRestServer;
import org.elasticmq.rest.stats.TheStatisticsRestServerBuilder$;
import org.elasticmq.server.config.ElasticMQServerConfig;
import org.elasticmq.util.Logging;
import org.elasticmq.util.NowProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public class ElasticMQServer
implements LazyLogging,
Logging {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ElasticMQServer.class.getDeclaredField("logger$lzy1"));
    private volatile transient Object logger$lzy1;
    private final ElasticMQServerConfig config;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;

    public ElasticMQServer(ElasticMQServerConfig config) {
        this.config = config;
        this.actorSystem = ActorSystem$.MODULE$.apply("elasticmq");
        this.ec = this.actorSystem.dispatcher();
        this.timeout = Timeout$.MODULE$.apply(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogging.logger$((LazyLogging)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public Function0<Terminated> start() {
        Future future;
        Option<ActorRef> queueConfigStore = this.createQueueEventListener();
        ActorRef queueManagerActor = this.createBase(queueConfigStore);
        Option<SQSRestServer> restServerOpt = this.optionallyStartRestSqs(queueManagerActor, queueConfigStore);
        Option<StatisticsRestServer> restStatisticsServerOpt = this.optionallyStartRestStatistics(queueManagerActor);
        Function0 & Serializable shutdown = (Function0 & Serializable)() -> {
            Future futureTerminationRestSQS = (Future)restServerOpt.map((Function1 & Serializable)_$1 -> (Future)_$1.stopAndGetFuture().apply()).getOrElse(ElasticMQServer::$anonfun$3);
            Future futureTerminationRestStats = (Future)restStatisticsServerOpt.map((Function1 & Serializable)_$2 -> (Future)_$2.stopAndGetFuture().apply()).getOrElse(ElasticMQServer::$anonfun$5);
            Future eventualTerminated = futureTerminationRestSQS.flatMap((Function1 & Serializable)x$12 -> {
                Object object = x$12;
                return futureTerminationRestStats.flatMap((Function1 & Serializable)x$1 -> {
                    Object object = x$1;
                    return this.actorSystem.terminate().map((Function1 & Serializable)ac -> ac, (ExecutionContext)this.ec());
                }, (ExecutionContext)this.ec());
            }, (ExecutionContext)this.ec());
            return (Terminated)Await$.MODULE$.result((Awaitable)eventualTerminated, (Duration)Duration$.MODULE$.Inf());
        };
        Function1 & Serializable logErrorsAndShutdown = (Function1 & Serializable)errors -> {
            errors.foreach((Function1)(JProcedure1 & Serializable)error -> {
                Logger LoggerImpl_this = this.logger();
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("Could not start server because {}", error);
                    return;
                }
            });
            return (Terminated)shutdown.apply();
        };
        Option<ActorRef> option = queueConfigStore;
        if (option instanceof Some) {
            ActorRef queueConfigStoreActor = (ActorRef)((Some)option).value();
            future = this.restoreQueuesViaQueueEventListener(queueConfigStoreActor, queueManagerActor).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    List errors = (List)((Some)option).value();
                    return logErrorsAndShutdown.apply((Object)errors);
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }, (ExecutionContext)this.ec());
        } else if (None$.MODULE$.equals(option)) {
            future = this.createQueuesFromConfig(queueManagerActor).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    List errors = (List)((Some)option).value();
                    return logErrorsAndShutdown.apply((Object)errors);
                }
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }, (ExecutionContext)this.ec());
        } else {
            throw new MatchError(option);
        }
        return shutdown;
    }

    private Option<ActorRef> createQueueEventListener() {
        if (this.config.sqlQueuePersistenceConfig().enabled()) {
            return Some$.MODULE$.apply((Object)this.actorSystem.actorOf(Props$.MODULE$.apply(this::createQueueEventListener$$anonfun$1, ClassTag$.MODULE$.apply(SqlQueuePersistenceActor.class))));
        }
        if (this.config.queuesStorageEnabled()) {
            return Some$.MODULE$.apply((Object)this.actorSystem.actorOf(Props$.MODULE$.apply(this::createQueueEventListener$$anonfun$2, ClassTag$.MODULE$.apply(ConfigBasedQueuePersistenceActor.class))));
        }
        return None$.MODULE$;
    }

    private ActorRef createBase(Option<ActorRef> queueConfigStore) {
        return this.actorSystem.actorOf(Props$.MODULE$.apply(() -> this.createBase$$anonfun$1(queueConfigStore), ClassTag$.MODULE$.apply(QueueManagerActor.class)));
    }

    private Option<SQSRestServer> optionallyStartRestSqs(ActorRef queueManagerActor, Option<ActorRef> queueConfigStore) {
        if (this.config.restSqs().enabled()) {
            SQSRestServer server = TheSQSRestServerBuilder$.MODULE$.apply((Option)Some$.MODULE$.apply((Object)this.actorSystem), (Option)Some$.MODULE$.apply((Object)queueManagerActor), this.config.restSqs().bindHostname(), this.config.restSqs().bindPort(), this.config.nodeAddress(), this.config.generateNodeAddress(), this.config.restSqs().sqsLimits(), this.config.awsRegion(), this.config.awsAccountId(), queueConfigStore).start();
            Http.ServerBinding _$5 = server.waitUntilStarted();
            return Some$.MODULE$.apply((Object)server);
        }
        return None$.MODULE$;
    }

    private Option<StatisticsRestServer> optionallyStartRestStatistics(ActorRef queueManagerActor) {
        if (this.config.restStatisticsConfiguration().enabled()) {
            StatisticsRestServer server = TheStatisticsRestServerBuilder$.MODULE$.apply(this.actorSystem, queueManagerActor, this.config.restStatisticsConfiguration().bindHostname(), this.config.restStatisticsConfiguration().bindPort(), this.config.awsRegion(), this.config.awsAccountId(), this.config.nodeAddress().contextPath()).start();
            Http.ServerBinding _$6 = server.waitUntilStarted();
            return Some$.MODULE$.apply((Object)server);
        }
        return None$.MODULE$;
    }

    private Future<Option<List<ElasticMQError>>> restoreQueuesViaQueueEventListener(ActorRef queueEventListenerActor, ActorRef queueManagerActor) {
        return org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueEventListenerActor).$qmark((Replyable)QueueEvent.Restore$.MODULE$.apply(queueManagerActor), this.timeout(), ClassTag$.MODULE$.apply(Either.class)).map((Function1 & Serializable)_$3 -> _$3.swap().toOption(), (ExecutionContext)this.ec());
    }

    private Future<Option<List<ElasticMQError>>> createQueuesFromConfig(ActorRef queueManagerActor) {
        List createQueuesFutures = this.config.baseQueues().map((Function1 & Serializable)createQueue -> org.elasticmq.actor.reply.package$.MODULE$.ReplyActorRef(queueManagerActor).$qmark((Replyable)CreateQueue$.MODULE$.apply(createQueue.toCreateQueueData()), this.timeout(), ClassTag$.MODULE$.apply(Either.class)).map((Function1 & Serializable)_$4 -> _$4.swap().toOption(), (ExecutionContext)this.ec()));
        return Future$.MODULE$.sequence((IterableOnce)createQueuesFutures, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.ec()).map((Function1 & Serializable)maybeErrors -> {
            List errors = (List)maybeErrors.flatten(Predef$.MODULE$.$conforms());
            if (errors.nonEmpty()) {
                return Some$.MODULE$.apply((Object)errors);
            }
            return None$.MODULE$;
        }, (ExecutionContext)this.ec());
    }

    private static final Future $anonfun$3() {
        return Future$.MODULE$.unit();
    }

    private static final Future $anonfun$5() {
        return Future$.MODULE$.unit();
    }

    private final SqlQueuePersistenceActor createQueueEventListener$$anonfun$1() {
        return new SqlQueuePersistenceActor(this.config.sqlQueuePersistenceConfig(), this.config.baseQueues());
    }

    private final ConfigBasedQueuePersistenceActor createQueueEventListener$$anonfun$2() {
        return new ConfigBasedQueuePersistenceActor(this.config.queuesStoragePath(), this.config.baseQueues());
    }

    private final QueueManagerActor createBase$$anonfun$1(Option queueConfigStore$1) {
        return new QueueManagerActor(new NowProvider(), this.config.restSqs().sqsLimits(), queueConfigStore$1);
    }
}

