/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.pekko.actor.Terminated;
import org.elasticmq.server.ElasticMQServer;
import org.elasticmq.server.config.ElasticMQServerConfig;
import org.elasticmq.util.Logging;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Main$
implements LazyLogging,
Logging,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Main$.class.getDeclaredField("logger$lzy1"));
    private volatile transient Object logger$lzy1;
    public static final Main$ MODULE$ = new Main$();

    private Main$() {
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogging.logger$((LazyLogging)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Main$.class);
    }

    public void main(String[] args) {
        long start = System.currentTimeMillis();
        String version = this.readVersion();
        Logger LoggerImpl_this = this.logger();
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Starting ElasticMQ server (%s) ..."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{version})));
        }
        this.logUncaughtExceptions();
        Config config = ConfigFactory.load();
        ElasticMQServer server = new ElasticMQServer(new ElasticMQServerConfig(config));
        Function0<Terminated> shutdown = server.start();
        this.addShutdownHook(shutdown);
        Logger LoggerImpl_this2 = this.logger();
        if (LoggerImpl_this2.underlying().isInfoEnabled()) {
            LoggerImpl_this2.underlying().info(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("=== ElasticMQ server (%s) started in %d ms ==="), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{version, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - start))})));
            return;
        }
    }

    private String readVersion() {
        InputStream stream = this.getClass().getResourceAsStream("/version");
        return (String)Source$.MODULE$.fromInputStream(stream, Codec$.MODULE$.fallbackSystemCodec()).getLines().next();
    }

    private void logUncaughtExceptions() {
        Thread.setDefaultUncaughtExceptionHandler((thread, ex) -> {
            Logger LoggerImpl_this = MODULE$.logger();
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error(new StringBuilder(30).append("Uncaught exception in thread: ").append(thread.getName()).toString(), ex);
                return;
            }
        });
    }

    private void addShutdownHook(Function0<Terminated> shutdown) {
        Runtime.getRuntime().addShutdownHook(new Thread(shutdown){
            private final Function0 shutdown$1;
            {
                this.shutdown$1 = shutdown$2;
            }

            public void run() {
                Logger LoggerImpl_this = Main$.MODULE$.logger();
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("ElasticMQ server stopping ...");
                }
                Terminated _$1 = (Terminated)this.shutdown$1.apply();
                Logger LoggerImpl_this2 = Main$.MODULE$.logger();
                if (LoggerImpl_this2.underlying().isInfoEnabled()) {
                    LoggerImpl_this2.underlying().info("=== ElasticMQ server stopped ===");
                    return;
                }
            }
        });
    }
}

