/*
 * Decompiled with CFR 0.152.
 */
package org.elasticmq.server.config;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.elasticmq.Limits;
import org.elasticmq.NodeAddress;
import org.elasticmq.NodeAddress$;
import org.elasticmq.RelaxedSQSLimits$;
import org.elasticmq.StrictSQSLimits$;
import org.elasticmq.persistence.CreateQueueMetadata;
import org.elasticmq.persistence.file.QueueConfigUtil$;
import org.elasticmq.persistence.sql.SqlQueuePersistenceConfig;
import org.elasticmq.persistence.sql.SqlQueuePersistenceConfig$;
import org.elasticmq.util.Logging;
import scala.collection.immutable.List;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class ElasticMQServerConfig
implements LazyLogging,
Logging {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ElasticMQServerConfig.class.getDeclaredField("logger$lzy1"));
    private volatile transient Object logger$lzy1;
    public final Config org$elasticmq$server$config$ElasticMQServerConfig$$config;
    private final NodeAddress nodeAddress;
    private final boolean generateNodeAddress;
    private final RestSqsConfiguration restSqs;
    private final RestStatisticsConfiguration restStatisticsConfiguration;
    private final String queuesStoragePath;
    private final boolean queuesStorageEnabled;
    private final String awsRegion;
    private final String awsAccountId;
    private final SqlQueuePersistenceConfig sqlQueuePersistenceConfig;
    private final List baseQueues;

    public ElasticMQServerConfig(Config config) {
        this.org$elasticmq$server$config$ElasticMQServerConfig$$config = config;
        Config subConfig = config.getConfig("node-address");
        this.nodeAddress = NodeAddress$.MODULE$.apply(subConfig.getString("protocol"), subConfig.getString("host"), subConfig.getInt("port"), subConfig.getString("context-path"));
        this.generateNodeAddress = config.getBoolean("generate-node-address");
        this.restSqs = new RestSqsConfiguration();
        this.restStatisticsConfiguration = new RestStatisticsConfiguration();
        Config queuesStorage = config.getConfig("queues-storage");
        this.queuesStoragePath = queuesStorage.getString("path");
        this.queuesStorageEnabled = queuesStorage.getBoolean("enabled");
        Config awsConfig = config.getConfig("aws");
        this.awsRegion = awsConfig.getString("region");
        this.awsAccountId = awsConfig.getString("accountId");
        this.sqlQueuePersistenceConfig = this.getSqlQueuePersistenceConfig();
        this.baseQueues = QueueConfigUtil$.MODULE$.readPersistedQueuesFromConfig(config);
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LazyLogging.logger$((LazyLogging)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public NodeAddress nodeAddress() {
        return this.nodeAddress;
    }

    public boolean generateNodeAddress() {
        return this.generateNodeAddress;
    }

    public RestSqsConfiguration restSqs() {
        return this.restSqs;
    }

    public RestStatisticsConfiguration restStatisticsConfiguration() {
        return this.restStatisticsConfiguration;
    }

    public String queuesStoragePath() {
        return this.queuesStoragePath;
    }

    public boolean queuesStorageEnabled() {
        return this.queuesStorageEnabled;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    private SqlQueuePersistenceConfig getSqlQueuePersistenceConfig() {
        Config subConfig = this.org$elasticmq$server$config$ElasticMQServerConfig$$config.getConfig("messages-storage");
        boolean enabled = subConfig.getBoolean("enabled");
        String driverClass = subConfig.getString("driver-class");
        String uri = subConfig.getString("uri");
        String username = subConfig.getString("username");
        String password = subConfig.getString("password");
        boolean pruneDataOnInit = subConfig.getBoolean("prune-data-on-init");
        return SqlQueuePersistenceConfig$.MODULE$.apply(enabled, driverClass, uri, username, password, pruneDataOnInit);
    }

    public SqlQueuePersistenceConfig sqlQueuePersistenceConfig() {
        return this.sqlQueuePersistenceConfig;
    }

    public List<CreateQueueMetadata> baseQueues() {
        return this.baseQueues;
    }

    public class RestSqsConfiguration {
        private final boolean enabled;
        private final int bindPort;
        private final String bindHostname;
        private final Limits sqsLimits;

        public RestSqsConfiguration() {
            RelaxedSQSLimits$ relaxedSQSLimits$;
            if (ElasticMQServerConfig.this == null) {
                throw new NullPointerException();
            }
            Config subConfig = ElasticMQServerConfig.this.org$elasticmq$server$config$ElasticMQServerConfig$$config.getConfig("rest-sqs");
            this.enabled = subConfig.getBoolean("enabled");
            this.bindPort = subConfig.getInt("bind-port");
            this.bindHostname = subConfig.getString("bind-hostname");
            String name = subConfig.getString("sqs-limits");
            if ("relaxed".equalsIgnoreCase(name)) {
                relaxedSQSLimits$ = RelaxedSQSLimits$.MODULE$;
            } else if ("strict".equalsIgnoreCase(name)) {
                relaxedSQSLimits$ = StrictSQSLimits$.MODULE$;
            } else {
                throw new IllegalArgumentException(new StringBuilder(25).append("Unknown sqs-limits name: ").append(name).toString());
            }
            this.sqsLimits = (Limits)relaxedSQSLimits$;
        }

        public boolean enabled() {
            return this.enabled;
        }

        public int bindPort() {
            return this.bindPort;
        }

        public String bindHostname() {
            return this.bindHostname;
        }

        public Limits sqsLimits() {
            return this.sqsLimits;
        }

        public final /* synthetic */ ElasticMQServerConfig org$elasticmq$server$config$ElasticMQServerConfig$RestSqsConfiguration$$$outer() {
            return ElasticMQServerConfig.this;
        }
    }

    public class RestStatisticsConfiguration {
        private final boolean enabled;
        private final int bindPort;
        private final String bindHostname;

        public RestStatisticsConfiguration() {
            if (ElasticMQServerConfig.this == null) {
                throw new NullPointerException();
            }
            Config subConfig = ElasticMQServerConfig.this.org$elasticmq$server$config$ElasticMQServerConfig$$config.getConfig("rest-stats");
            this.enabled = subConfig.getBoolean("enabled");
            this.bindPort = subConfig.getInt("bind-port");
            this.bindHostname = subConfig.getString("bind-hostname");
        }

        public boolean enabled() {
            return this.enabled;
        }

        public int bindPort() {
            return this.bindPort;
        }

        public String bindHostname() {
            return this.bindHostname;
        }

        public final /* synthetic */ ElasticMQServerConfig org$elasticmq$server$config$ElasticMQServerConfig$RestStatisticsConfiguration$$$outer() {
            return ElasticMQServerConfig.this;
        }
    }
}

