/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.client.http.ContentTooLongException;
import org.elasticsearch.client.http.HttpEntity;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.entity.ContentType;
import org.elasticsearch.client.http.nio.ContentDecoder;
import org.elasticsearch.client.http.nio.IOControl;
import org.elasticsearch.client.http.nio.entity.ContentBufferEntity;
import org.elasticsearch.client.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.elasticsearch.client.http.nio.util.ByteBufferAllocator;
import org.elasticsearch.client.http.nio.util.HeapByteBufferAllocator;
import org.elasticsearch.client.http.nio.util.SimpleInputBuffer;
import org.elasticsearch.client.http.protocol.HttpContext;

public class HeapBufferedAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private final int bufferLimitBytes;
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    public HeapBufferedAsyncResponseConsumer(int bufferLimit) {
        if (bufferLimit <= 0) {
            throw new IllegalArgumentException("bufferLimit must be greater than 0");
        }
        this.bufferLimitBytes = bufferLimit;
    }

    public int getBufferLimit() {
        return this.bufferLimitBytes;
    }

    @Override
    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > (long)this.bufferLimitBytes) {
            throw new ContentTooLongException("entity content is too long [" + len + "] for the configured buffer limit [" + this.bufferLimitBytes + "]");
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, this.getByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    protected ByteBufferAllocator getByteBufferAllocator() {
        return HeapByteBufferAllocator.INSTANCE;
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.buf.consumeContent(decoder);
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) throws Exception {
        return this.response;
    }

    @Override
    protected void releaseResources() {
        this.response = null;
    }
}

