/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.Objects;
import org.elasticsearch.client.http.Header;
import org.elasticsearch.client.http.HttpEntity;
import org.elasticsearch.client.http.HttpHost;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.RequestLine;
import org.elasticsearch.client.http.StatusLine;

public class Response {
    private final RequestLine requestLine;
    private final HttpHost host;
    private final HttpResponse response;

    Response(RequestLine requestLine, HttpHost host, HttpResponse response) {
        Objects.requireNonNull(requestLine, "requestLine cannot be null");
        Objects.requireNonNull(host, "node cannot be null");
        Objects.requireNonNull(response, "response cannot be null");
        this.requestLine = requestLine;
        this.host = host;
        this.response = response;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public Header[] getHeaders() {
        return this.response.getAllHeaders();
    }

    public String getHeader(String name) {
        Header header = this.response.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public HttpEntity getEntity() {
        return this.response.getEntity();
    }

    HttpResponse getHttpResponse() {
        return this.response;
    }

    public String toString() {
        return "Response{requestLine=" + this.requestLine + ", host=" + this.host + ", response=" + this.response.getStatusLine() + '}';
    }
}

