/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.auth;

import org.elasticsearch.client.http.annotation.Immutable;
import org.elasticsearch.client.http.auth.AuthScheme;
import org.elasticsearch.client.http.auth.AuthSchemeFactory;
import org.elasticsearch.client.http.auth.AuthSchemeProvider;
import org.elasticsearch.client.http.impl.auth.SPNegoScheme;
import org.elasticsearch.client.http.params.HttpParams;
import org.elasticsearch.client.http.protocol.HttpContext;

@Immutable
public class SPNegoSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public SPNegoSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public SPNegoSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public SPNegoSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }
}

