/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.client;

import java.io.IOException;
import org.elasticsearch.client.http.HttpEntity;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.StatusLine;
import org.elasticsearch.client.http.annotation.Immutable;
import org.elasticsearch.client.http.client.HttpResponseException;
import org.elasticsearch.client.http.client.ResponseHandler;
import org.elasticsearch.client.http.util.EntityUtils;

@Immutable
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

