/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.client;

import org.elasticsearch.client.http.Header;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.impl.DefaultConnectionReuseStrategy;
import org.elasticsearch.client.http.message.BasicHeaderIterator;
import org.elasticsearch.client.http.message.BasicTokenIterator;
import org.elasticsearch.client.http.protocol.HttpContext;

public class DefaultClientConnectionReuseStrategy
extends DefaultConnectionReuseStrategy {
    public static final DefaultClientConnectionReuseStrategy INSTANCE = new DefaultClientConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpResponse response, HttpContext context) {
        Header[] connHeaders;
        HttpRequest request = (HttpRequest)context.getAttribute("http.request");
        if (request != null && (connHeaders = request.getHeaders("Connection")).length != 0) {
            BasicTokenIterator ti = new BasicTokenIterator(new BasicHeaderIterator(connHeaders, null));
            while (ti.hasNext()) {
                String token = ti.nextToken();
                if (!"Close".equalsIgnoreCase(token)) continue;
                return false;
            }
        }
        return super.keepAlive(response, context);
    }
}

