/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.client;

import org.elasticsearch.client.http.HeaderElement;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.annotation.Immutable;
import org.elasticsearch.client.http.conn.ConnectionKeepAliveStrategy;
import org.elasticsearch.client.http.message.BasicHeaderElementIterator;
import org.elasticsearch.client.http.protocol.HttpContext;
import org.elasticsearch.client.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

