/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpHost;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.annotation.ThreadSafe;
import org.elasticsearch.client.http.client.ClientProtocolException;
import org.elasticsearch.client.http.client.config.RequestConfig;
import org.elasticsearch.client.http.client.methods.CloseableHttpResponse;
import org.elasticsearch.client.http.client.methods.Configurable;
import org.elasticsearch.client.http.client.methods.HttpExecutionAware;
import org.elasticsearch.client.http.client.methods.HttpRequestWrapper;
import org.elasticsearch.client.http.client.protocol.HttpClientContext;
import org.elasticsearch.client.http.conn.ClientConnectionManager;
import org.elasticsearch.client.http.conn.ClientConnectionRequest;
import org.elasticsearch.client.http.conn.HttpClientConnectionManager;
import org.elasticsearch.client.http.conn.ManagedClientConnection;
import org.elasticsearch.client.http.conn.routing.HttpRoute;
import org.elasticsearch.client.http.conn.scheme.SchemeRegistry;
import org.elasticsearch.client.http.impl.DefaultConnectionReuseStrategy;
import org.elasticsearch.client.http.impl.client.CloseableHttpClient;
import org.elasticsearch.client.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.elasticsearch.client.http.impl.execchain.MinimalClientExec;
import org.elasticsearch.client.http.params.BasicHttpParams;
import org.elasticsearch.client.http.params.HttpParams;
import org.elasticsearch.client.http.protocol.BasicHttpContext;
import org.elasticsearch.client.http.protocol.HttpContext;
import org.elasticsearch.client.http.protocol.HttpRequestExecutor;
import org.elasticsearch.client.http.util.Args;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

