/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.conn;

import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.HttpResponseFactory;
import org.elasticsearch.client.http.annotation.Immutable;
import org.elasticsearch.client.http.config.MessageConstraints;
import org.elasticsearch.client.http.impl.DefaultHttpResponseFactory;
import org.elasticsearch.client.http.impl.conn.DefaultHttpResponseParser;
import org.elasticsearch.client.http.io.HttpMessageParser;
import org.elasticsearch.client.http.io.HttpMessageParserFactory;
import org.elasticsearch.client.http.io.SessionInputBuffer;
import org.elasticsearch.client.http.message.BasicLineParser;
import org.elasticsearch.client.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

