/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.conn;

import java.io.IOException;
import org.elasticsearch.client.commons.logging.Log;
import org.elasticsearch.client.commons.logging.LogFactory;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpMessage;
import org.elasticsearch.client.http.HttpResponseFactory;
import org.elasticsearch.client.http.NoHttpResponseException;
import org.elasticsearch.client.http.ProtocolException;
import org.elasticsearch.client.http.StatusLine;
import org.elasticsearch.client.http.annotation.ThreadSafe;
import org.elasticsearch.client.http.impl.io.AbstractMessageParser;
import org.elasticsearch.client.http.io.SessionInputBuffer;
import org.elasticsearch.client.http.message.LineParser;
import org.elasticsearch.client.http.message.ParserCursor;
import org.elasticsearch.client.http.params.HttpParams;
import org.elasticsearch.client.http.util.Args;
import org.elasticsearch.client.http.util.CharArrayBuffer;

@Deprecated
@ThreadSafe
public class DefaultResponseParser
extends AbstractMessageParser<HttpMessage> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;
    private final int maxGarbageLines;

    public DefaultResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, parser, params);
        Args.notNull(responseFactory, "Response factory");
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
        this.maxGarbageLines = this.getMaxGarbageLines(params);
    }

    protected int getMaxGarbageLines(HttpParams params) {
        return params.getIntParameter("http.connection.max-status-line-garbage", Integer.MAX_VALUE);
    }

    @Override
    protected HttpMessage parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException {
        int count = 0;
        ParserCursor cursor = null;
        while (true) {
            this.lineBuf.clear();
            int i = sessionBuffer.readLine(this.lineBuf);
            if (i == -1 && count == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            cursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, cursor)) break;
            if (i == -1 || count >= this.maxGarbageLines) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Garbage in response: " + this.lineBuf.toString());
            }
            ++count;
        }
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

