/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.conn;

import org.elasticsearch.client.http.HttpHost;
import org.elasticsearch.client.http.annotation.Immutable;
import org.elasticsearch.client.http.conn.SchemePortResolver;
import org.elasticsearch.client.http.conn.UnsupportedSchemeException;
import org.elasticsearch.client.http.util.Args;

@Immutable
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        Args.notNull(host, "HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name = host.getSchemeName();
        if (name.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name + " protocol is not supported");
    }
}

