/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.cookie;

import org.elasticsearch.client.http.annotation.Immutable;
import org.elasticsearch.client.http.cookie.CommonCookieAttributeHandler;
import org.elasticsearch.client.http.cookie.Cookie;
import org.elasticsearch.client.http.cookie.CookieOrigin;
import org.elasticsearch.client.http.cookie.MalformedCookieException;
import org.elasticsearch.client.http.cookie.SetCookie;
import org.elasticsearch.client.http.impl.cookie.AbstractCookieAttributeHandler;
import org.elasticsearch.client.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

