/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.cookie;

import org.elasticsearch.client.http.annotation.Immutable;
import org.elasticsearch.client.http.cookie.ClientCookie;
import org.elasticsearch.client.http.cookie.CommonCookieAttributeHandler;
import org.elasticsearch.client.http.cookie.Cookie;
import org.elasticsearch.client.http.cookie.CookieOrigin;
import org.elasticsearch.client.http.cookie.CookieRestrictionViolationException;
import org.elasticsearch.client.http.cookie.MalformedCookieException;
import org.elasticsearch.client.http.cookie.SetCookie;
import org.elasticsearch.client.http.cookie.SetCookie2;
import org.elasticsearch.client.http.util.Args;

@Immutable
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

