/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.cookie;

import org.elasticsearch.client.http.annotation.Immutable;
import org.elasticsearch.client.http.conn.util.PublicSuffixMatcher;
import org.elasticsearch.client.http.cookie.Cookie;
import org.elasticsearch.client.http.cookie.CookieOrigin;
import org.elasticsearch.client.http.cookie.CookieSpec;
import org.elasticsearch.client.http.cookie.CookieSpecProvider;
import org.elasticsearch.client.http.cookie.MalformedCookieException;
import org.elasticsearch.client.http.impl.cookie.BasicDomainHandler;
import org.elasticsearch.client.http.impl.cookie.BasicExpiresHandler;
import org.elasticsearch.client.http.impl.cookie.BasicMaxAgeHandler;
import org.elasticsearch.client.http.impl.cookie.BasicPathHandler;
import org.elasticsearch.client.http.impl.cookie.BasicSecureHandler;
import org.elasticsearch.client.http.impl.cookie.LaxExpiresHandler;
import org.elasticsearch.client.http.impl.cookie.LaxMaxAgeHandler;
import org.elasticsearch.client.http.impl.cookie.PublicSuffixDomainFilter;
import org.elasticsearch.client.http.impl.cookie.RFC6265LaxSpec;
import org.elasticsearch.client.http.impl.cookie.RFC6265StrictSpec;
import org.elasticsearch.client.http.protocol.HttpContext;

@Immutable
public class RFC6265CookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public RFC6265CookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.RELAXED, publicSuffixMatcher);
    }

    public RFC6265CookieSpecProvider() {
        this(CompatibilityLevel.RELAXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec == null) {
            RFC6265CookieSpecProvider rFC6265CookieSpecProvider = this;
            synchronized (rFC6265CookieSpecProvider) {
                if (this.cookieSpec == null) {
                    switch (this.compatibilityLevel) {
                        case STRICT: {
                            this.cookieSpec = new RFC6265StrictSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        case IE_MEDIUM_SECURITY: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(){

                                @Override
                                public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                                }
                            }, PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        default: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new LaxMaxAgeHandler(), new BasicSecureHandler(), new LaxExpiresHandler());
                        }
                    }
                }
            }
        }
        return this.cookieSpec;
    }

    public static enum CompatibilityLevel {
        STRICT,
        RELAXED,
        IE_MEDIUM_SECURITY;

    }
}

