/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.entity;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.client.http.HttpEntity;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpMessage;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.entity.ContentLengthStrategy;
import org.elasticsearch.client.http.impl.io.ChunkedOutputStream;
import org.elasticsearch.client.http.impl.io.ContentLengthOutputStream;
import org.elasticsearch.client.http.impl.io.IdentityOutputStream;
import org.elasticsearch.client.http.io.SessionOutputBuffer;
import org.elasticsearch.client.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntitySerializer {
    private final ContentLengthStrategy lenStrategy;

    public EntitySerializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected OutputStream doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            return new ChunkedOutputStream(outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream(outbuffer, len);
    }

    public void serialize(SessionOutputBuffer outbuffer, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        Args.notNull(outbuffer, "Session output buffer");
        Args.notNull(message, "HTTP message");
        Args.notNull(entity, "HTTP entity");
        OutputStream outstream = this.doSerialize(outbuffer, message);
        entity.writeTo(outstream);
        outstream.close();
    }
}

