/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.io;

import java.io.IOException;
import org.elasticsearch.client.http.ConnectionClosedException;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpRequestFactory;
import org.elasticsearch.client.http.ParseException;
import org.elasticsearch.client.http.RequestLine;
import org.elasticsearch.client.http.config.MessageConstraints;
import org.elasticsearch.client.http.impl.DefaultHttpRequestFactory;
import org.elasticsearch.client.http.impl.io.AbstractMessageParser;
import org.elasticsearch.client.http.io.SessionInputBuffer;
import org.elasticsearch.client.http.message.LineParser;
import org.elasticsearch.client.http.message.ParserCursor;
import org.elasticsearch.client.http.params.HttpParams;
import org.elasticsearch.client.http.util.Args;
import org.elasticsearch.client.http.util.CharArrayBuffer;

public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpRequestParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpRequest parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

