/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.io;

import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.impl.io.DefaultHttpRequestWriter;
import org.elasticsearch.client.http.io.HttpMessageWriter;
import org.elasticsearch.client.http.io.HttpMessageWriterFactory;
import org.elasticsearch.client.http.io.SessionOutputBuffer;
import org.elasticsearch.client.http.message.BasicLineFormatter;
import org.elasticsearch.client.http.message.LineFormatter;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestWriterFactory
implements HttpMessageWriterFactory<HttpRequest> {
    public static final DefaultHttpRequestWriterFactory INSTANCE = new DefaultHttpRequestWriterFactory();
    private final LineFormatter lineFormatter;

    public DefaultHttpRequestWriterFactory(LineFormatter lineFormatter) {
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
    }

    public DefaultHttpRequestWriterFactory() {
        this(null);
    }

    @Override
    public HttpMessageWriter<HttpRequest> create(SessionOutputBuffer buffer) {
        return new DefaultHttpRequestWriter(buffer, this.lineFormatter);
    }
}

